include(FindPackageHandleStandardArgs)

find_path(TINYXML_INCLUDE_DIR NAMES tinyxml.h)
find_library(TINYXML_LIBRARY NAMES tinyxml)
find_path(TINYXML_SOURCE_DIR NAMES tinyxml.cpp)

if (TINYXML_SOURCE_DIR)
    find_package_handle_standard_args(TinyXML DEFAULT_MSG
        TINYXML_INCLUDE_DIR TINYXML_SOURCE_DIR)
else ()
    find_package_handle_standard_args(TinyXML DEFAULT_MSG
        TINYXML_INCLUDE_DIR TINYXML_LIBRARY)
endif ()

if (TINYXML_SOURCE_DIR)
    cmake_policy(PUSH)
    if (POLICY CMP0063)
        # Apply visibility target properties to static libraries also.
        cmake_policy(SET CMP0063 NEW)
    endif ()

    add_library(foundry.katana.thirdparty.tinyxml STATIC EXCLUDE_FROM_ALL
        "${TINYXML_SOURCE_DIR}/tinyxml.cpp"
        "${TINYXML_SOURCE_DIR}/tinyxmlerror.cpp"
        "${TINYXML_SOURCE_DIR}/tinyxmlparser.cpp")
    target_include_directories(foundry.katana.thirdparty.tinyxml PUBLIC
        "${TINYXML_INCLUDE_DIR}")
    target_compile_definitions(foundry.katana.thirdparty.tinyxml PUBLIC
        "TIXML_USE_STL")
    set_target_properties(foundry.katana.thirdparty.tinyxml PROPERTIES
        POSITION_INDEPENDENT_CODE TRUE
        CXX_VISIBILITY_PRESET "hidden"
        VISIBILITY_INLINES_HIDDEN TRUE)

    set(TINYXML_LIBRARY "foundry.katana.thirdparty.tinyxml")

    if (NOT TARGET TinyXML::TinyXML)
        add_library(TinyXML::TinyXML ALIAS foundry.katana.thirdparty.tinyxml)
    endif ()

    cmake_policy(POP)

elseif (TINYXML_LIBRARY)
    if (NOT TARGET TinyXML::TinyXML)
        add_library(TinyXML::TinyXML UNKNOWN IMPORTED)
        set_target_properties(TinyXML::TinyXML PROPERTIES
            INTERFACE_INCLUDE_DIRECTORIES "${TINYXML_INCLUDE_DIR}"
            INTERFACE_COMPILE_DEFINITIONS "TIXML_USE_STL"
            IMPORTED_LOCATION "${TINYXML_LIBRARY}")
    endif ()
endif ()

set(TINYXML_INCLUDE_DIRS "${TINYXML_INCLUDE_DIR}")
set(TINYXML_LIBRARIES "${TINYXML_LIBRARY}")
set(TINYXML_DEFINITIONS "TIXML_USE_STL")
