#ifndef TRANSFORM_MANIPULATORS_FNMANIPULATORSCONFIG_H
#define TRANSFORM_MANIPULATORS_FNMANIPULATORSCONFIG_H

#include <FnViewer/plugin/FnMathTypes.h>

namespace FnManipulators
{
    // Hydra viewer expects colors defined in linear rgb colorspace.

    using Foundry::Katana::ViewerAPI::Vec4f;

    static const float GuideFactor = 0.65f;

    static const Vec4f HandleColorX(0.75f, 0.00f, 0.01f, 1.0f);
    static const Vec4f HandleColorY(0.00f, 0.68f, 0.12f, 1.0f);
    static const Vec4f HandleColorZ(0.07f, 0.29f, 0.77f, 1.0f);

    static const Vec4f HandleColorXY = HandleColorX;
    static const Vec4f HandleColorXZ = HandleColorZ;
    static const Vec4f HandleColorYZ = HandleColorY;

    static const Vec4f HandleColorCentre(1.f, 1.f, 1.f, 0.5f);
    static const Vec4f HandleColorCentreOpaque(1.f, 1.f, 1.f, 0.5f);

    // modifies the original colors to be used in the coi manipulators
    static const float kAlternativeColorFactor = 0.75f;

    static const Vec4f HandleAlternativeColorX(
        HandleColorX.x * kAlternativeColorFactor,
        HandleColorX.y * kAlternativeColorFactor,
        HandleColorX.z * kAlternativeColorFactor,
        HandleColorX.w);
    static const Vec4f HandleAlternativeColorY(
        HandleColorY.x * kAlternativeColorFactor,
        HandleColorY.y * kAlternativeColorFactor,
        HandleColorY.z * kAlternativeColorFactor,
        HandleColorY.w);
    static const Vec4f HandleAlternativeColorZ(
        HandleColorZ.x * kAlternativeColorFactor,
        HandleColorZ.y * kAlternativeColorFactor,
        HandleColorZ.z * kAlternativeColorFactor,
        HandleColorZ.w);

    static const Vec4f HandleAlternativeColorXY = HandleAlternativeColorX;
    static const Vec4f HandleAlternativeColorXZ = HandleAlternativeColorZ;
    static const Vec4f HandleAlternativeColorYZ = HandleAlternativeColorY;

    static const Vec4f HandleAlternativeColorCentre(
        HandleColorCentre.x * kAlternativeColorFactor,
        HandleColorCentre.y * kAlternativeColorFactor,
        HandleColorCentre.z * kAlternativeColorFactor,
        HandleColorCentre.w);
    static const Vec4f HandleAlternativeColorCentreOpaque(
        HandleColorCentreOpaque.x * kAlternativeColorFactor,
        HandleColorCentreOpaque.y * kAlternativeColorFactor,
        HandleColorCentreOpaque.z * kAlternativeColorFactor,
        HandleColorCentreOpaque.w);

    static const Vec4f HandleColorActive(0.83f, 0.49f, 0.02f, 1.0f);
    static const Vec4f HandleColorHover(0.89f, 0.66f, 0.21f, 1.0f);
    static const Vec4f HandleColorDrag(0.52f, 0.33f, 0.03f, 1.0f);
    static const Vec4f HandleColorNonInteractive(0.22f, 0.22f, 0.22f, 0.61f);

    static const float HandleTrunkLength = 1.55f;
    static const float HandleTrunkRadius = 0.016f;
    static const float HandlePlaneThickness = HandleTrunkRadius * 2.0f;

    static const float TranslateConeLength = 0.4f;
    static const float TranslateConeRadius = 0.118f;
    static const float TranslateSquareLength = 0.35f;
    static const float TranslatePlaneTriangleLength = 0.34f;
    static const float TranslatePlaneDistanceToOrigin = 0.6f;
    static const float TranslateCoiScale = 0.7f;
    static const float TranslateCoiPlaneDistanceToOrigin = 1.1f;

    static const float ScaleCubeLength = 0.236f;
    static const float ScaleUniformCubeLength = 0.3f;
    static const float ScalePlaneSquareLength = 0.3f;
    static const float ScalePlaneDistanceToOrigin = 0.6f;

    static const float RotateAroundCoiRadiusScale = 0.55f;
    static const float RotateViewRadius = 1.70f;
    static const float RotateSliceRadiusScale = 0.94f;
    static const int RotateSliceLineWidth = 1;
    static const Vec4f RotateSliceColor(1, 1, 1, 0.2f);
    static const Vec4f RotateSliceOutlineColor(1, 1, 1, 0.5f);
    static const Vec4f RotateBallColor(0.07f, 0.28f, 0.77f, 0.1f);
    static const Vec4f RotateBallAlternativeColor(
        RotateBallColor.x * kAlternativeColorFactor,
        RotateBallColor.y * kAlternativeColorFactor,
        RotateBallColor.z * kAlternativeColorFactor,
        RotateBallColor.w);

    static const int CoiLinePattern = 0x00FF00FF;
    static const float CoiLinePatternFactor = 0.6f;
    static const unsigned int CoiLineWidth = 2;
    static const Vec4f CoiLineColor(
        HandleColorZ.x * GuideFactor,
        HandleColorZ.y * GuideFactor,
        HandleColorZ.z * GuideFactor,
        1.0f);
    static const unsigned int CoiCrossLineWidth = 1;
    static const float CoiCrossLineLength = 0.1f;
    static const Vec4f CoiCrossColor(1.0f, 1.0f, 1.0f, 1.0f);

    static const int LightingLinePattern = 0x00FF00FF;
    static const float LightingLinePatternFactor = 0.4f;
    static const unsigned int LightingLineWidth = 2;
    static const Vec4f LightingLineHandleColor(
        0.82279f,
        0.47353f,
        0.02217f,
        1.0f);  // Linear RGB: 234, 183, 41
    static const Vec4f LightingLineColor(0.7f,
                                         0.7f,
                                         0.7f,
                                         1.0f);

}  // namespace FnManipulators

#endif  // TRANSFORM_MANIPULATORS_FNMANIPULATORSCONFIG_H
