// Copyright (c) 2018 The Foundry Visionmongers Ltd. All Rights Reserved.

#include "ExampleSpotlightLocator.h"

/**
 * Locator plug-ins are a simple way to add custom drawing for certain types
 * of scene graph location. The classes found in FnViewer/utils/FnBaseLocator.h
 * are designed to be compiled into a plug-in and work without any additional
 * changes. This example creates derived classes for demonstration purposes,
 * but if no changes on the base implementations are needed the following
 * code would be how you might re-use the base classes directly.
 *
 * namespace Foundry {
 *     namespace Katana {
 *         namespace ViewerUtils {
 *             DEFINE_VIEWER_DELEGATE_COMPONENT_PLUGIN(FnBaseLocatorVDC);
 *             DEFINE_VIEWPORT_LAYER_PLUGIN(FnBaseLocatorViewportLayer);
 *         }  // ViewerUtils
 *     }  // Katana
 * }  // Foundry
 *
 * void registerPlugins()
 * {
 *     REGISTER_PLUGIN(Foundry::Katana::ViewerUtils::FnBaseLocatorVDC,
 *                     "ExampleSpotlightLocatorVDC", 0, 1);
 *     REGISTER_PLUGIN(Foundry::Katana::ViewerUtils::FnBaseLocatorViewportLayer,
 *                     "ExampleSpotlightLocatorViewportLayer", 0, 1);
 *
 *     REGISTER_LOCATOR(ExampleSpotlightLocator);
 * }
 */

DEFINE_VIEWER_DELEGATE_COMPONENT_PLUGIN(ExampleSpotlightLocatorVDC);
DEFINE_VIEWPORT_LAYER_PLUGIN(ExampleSpotlightLocatorViewportLayer);

void registerPlugins()
{
    // Register the ViewerDelegateComponent and ViewportLayer plug-ins
    REGISTER_PLUGIN(ExampleSpotlightLocatorVDC,
                    "ExampleSpotlightLocatorVDC", 0, 1);
    REGISTER_PLUGIN(ExampleSpotlightLocatorViewportLayer,
                    "ExampleSpotlightLocatorViewportLayer", 0, 1);

    // Register the locator class with the ExampleSpotlightLocatorVDC class
    REGISTER_LOCATOR(ExampleSpotlightLocator);

    // Register any additional locators...
    // ...
}
