// Copyright (c) 2018 The Foundry Visionmongers Ltd. All Rights Reserved.

#include "ProfilingMockRenderer/ProfilingMockRenderPlugin.h"
#include "ProfilingMockRenderer/ProfilingMockRendererInfoPlugin.h"

using ProfilingMockRenderer::RenderPlugin;
using ProfilingMockRenderer::RendererInfoPlugin;

namespace
{
DEFINE_RENDER_PLUGIN(RenderPlugin)
DEFINE_RENDERERINFO_PLUGIN(RendererInfoPlugin)
}

// The plug-ins will be registered inside the `registerPlugins()` function.
// Katana's plug-in system will inspect all shared objects in pursuit of this
// function. When found, the function will be invoked, and the plug-ins will be
// registered.
void registerPlugins()
{
    REGISTER_PLUGIN(RenderPlugin, "profilingMockRenderer", 0, 1);
    REGISTER_PLUGIN(RendererInfoPlugin, "profilingMockRendererInfo", 0, 1);
}
