// Copyright (c) 2018 The Foundry Visionmongers Ltd. All Rights Reserved.

#include "ProfilingMockRenderer/ProfilingMockRendererInfoPlugin.h"

#include <string>
#include <vector>

namespace ProfilingMockRenderer
{
RendererInfoPlugin::RendererInfoPlugin()
{
}

RendererInfoPlugin::~RendererInfoPlugin()
{
}

FnKat::RendererInfo::RendererInfoBase* RendererInfoPlugin::create()
{
    return new RendererInfoPlugin();
}

void RendererInfoPlugin::configureBatchRenderMethod(
    FnKat::RendererInfo::DiskRenderMethod& batchRenderMethod) const
{
}

void RendererInfoPlugin::fillRenderMethods(
    std::vector<FnKat::RendererInfo::RenderMethod*>& renderMethods) const
{
    // Support for Preview Render.
    FnKat::RendererInfo::PreviewRenderMethod* const previewRenderMethod =
        new FnKat::RendererInfo::PreviewRenderMethod();
    previewRenderMethod->setName("previewRender");
    previewRenderMethod->setLabel("Preview Render");
    renderMethods.push_back(previewRenderMethod);

    // Support for Disk Render.
    FnKat::RendererInfo::DiskRenderMethod* const diskRenderMethod =
        new FnKat::RendererInfo::DiskRenderMethod();
    diskRenderMethod->setName("diskRender");
    diskRenderMethod->setLabel("Disk Render");
    renderMethods.push_back(diskRenderMethod);
}

void RendererInfoPlugin::fillRendererObjectTypes(
    std::vector<std::string>& renderObjectTypes,
    const std::string& type) const
{
    // no new object types
}

void RendererInfoPlugin::fillRendererObjectNames(
    std::vector<std::string>& rendererObjectNames,
    const std::string& type,
    const std::vector<std::string>& typeTags) const
{
}

std::string RendererInfoPlugin::getRegisteredRendererName() const
{
    return "profilingMockRenderer";
}

std::string RendererInfoPlugin::getRegisteredRendererVersion() const
{
    return "1.0";
}

bool RendererInfoPlugin::buildRendererObjectInfo(
    FnAttribute::GroupBuilder& rendererObjectInfo,
    const std::string& name,
    const std::string& type,
    const FnAttribute::GroupAttribute inputAttr) const
{
    return false;
}

}  // namespace ProfilingMockRenderer
