// Copyright (c) 2018 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef KATANA_PLUGINS_PROFILINGMOCKRENDERER_PROFILINGMOCKRENDERERINFOPLUGIN_H_
#define KATANA_PLUGINS_PROFILINGMOCKRENDERER_PROFILINGMOCKRENDERERINFOPLUGIN_H_

#include <string>
#include <vector>

#include <FnAttribute/FnAttribute.h>
#include <FnRendererInfo/plugin/RendererInfoBase.h>

namespace ProfilingMockRenderer
{
/**
 * \defgroup ProfilingMockRenderer Profiling Mock Renderer Plug-in
 * \{
 */

/**
 * \brief This plug-in registers and defines the <b>Profiling Mock Renderer</b>
 * render plug-in.
 *
 * The display name of the renderer is \c profilingMockRenderer. It supports
 * <b>Preview Render</b> and <b>Disk Render</b>.
 *
 * \see ProfilingMockRenderer::RenderPlugin
 */
class RendererInfoPlugin : public FnKat::RendererInfo::RendererInfoBase
{
public:
    /** \brief Constructor. */
    RendererInfoPlugin();

    /** \brief Destructor. */
    ~RendererInfoPlugin() override;

    /** \brief Constructs an intance of the class.
     *
     * This is used by the \c DEFINE_RENDERERINFO_PLUGIN macro.
     *
     * \return A pointer to the new instance.
     */
    static FnKat::RendererInfo::RendererInfoBase* create();

    static void flush() {}

    /* RendererInfoBase Methods */

    /** \brief Reimplemented from \c RendererInfoBase.
     *
     * The <b>Batch Render</b> method is always available. Although the
     * <b>Profiling Mock Renderer</b> plug-in does not require any specific
     * configuration, this function allows customization if needed.
     */
    void configureBatchRenderMethod(FnKat::RendererInfo::DiskRenderMethod&
                                        batchRenderMethod) const override;

    /** \brief Reimplemented from \c RendererInfoBase.
     *
     * Other render methods can be added here. <b>Disk Render</b> and
     * <b>Preview Render</b> are the two methods (apart from the <b>Batch
     * Render</b> method) that will be added for this plug-in.
     *
     * \param renderMethods Output list where the new render methods will be
     *     added.
     */
    void fillRenderMethods(std::vector<FnKat::RendererInfo::RenderMethod*>&
                               renderMethods) const override;

    /** \brief Reimplemented from \c RendererInfoBase.
     *
     * The Profiling Mock Renderer does not add extra renderer objects.
     */
    void fillRendererObjectTypes(std::vector<std::string>& renderObjectTypes,
                                 const std::string& type) const override;

    /** \brief Reimplemented from \c RendererInfoBase.
     *
     * The Profiling Mock Renderer does not add extra renderer objects.
     */
    void fillRendererObjectNames(
        std::vector<std::string>& rendererObjectNames,
        const std::string& type,
        const std::vector<std::string>& typeTags) const override;

    /** \brief Reimplemented from \c RendererInfoBase.
     *
     * The Profiling Mock Renderer is registered as \c profilingMockRenderer.
     */
    std::string getRegisteredRendererName() const override;

    /** \brief Reimplemented from \c RendererInfoBase.
     *
     * This returns the version of the Profiling Mock Renderer plug-in.
     */
    std::string getRegisteredRendererVersion() const override;

    /** \brief Reimplemented from \c RendererInfoBase.
     *
     * The Profiling Mock Renderer does not add extra renderer objects.
     */
    bool buildRendererObjectInfo(
        FnAttribute::GroupBuilder& rendererObjectInfo,
        const std::string& name,
        const std::string& type,
        const FnAttribute::GroupAttribute inputAttr) const override;
};

/** \} */

}  // namespace ProfilingMockRenderer

#endif  // KATANA_PLUGINS_PROFILINGMOCKRENDERER_PROFILINGMOCKRENDERERINFOPLUGIN_H_
