#include <iostream>
#include <string>
#include <FnAttribute/FnAttribute.h>
#include <FnAttribute/FnGroupBuilder.h>

#include <FnPluginSystem/FnPlugin.h>

#include <FnGeolib/op/FnGeolibOp.h>

#include <FnGeolib/util/Path.h>

#include <FnGeolibServices/FnGeolibCookInterfaceUtilsService.h>

namespace
{  // anonymous

class PruneOp : public Foundry::Katana::GeolibOp
{
public:
    static void setup(Foundry::Katana::GeolibSetupInterface& interface)
    {
        interface.setThreading(
            Foundry::Katana::GeolibSetupInterface::ThreadModeConcurrent);
        interface.setOpsCollapsible(FnAttribute::StringAttribute("batch"));
    }

    static void apply(Foundry::Katana::GeolibCookInterface& interface,
                      const std::string& fullName,
                      const FnAttribute::GroupAttribute& args,
                      bool& canMatchChildren)
    {
        FnAttribute::StringAttribute pathsAttr = args.getChildByName("paths");

        if (pathsAttr.isValid())
        {
            FnAttribute::StringConstVector paths =
                pathsAttr.getNearestSample(0.0f);

            for (auto path : paths)
            {
                FnGeolibUtil::Path::FnMatchInfo fnMatchInfo;
                FnGeolibUtil::Path::FnMatch(fnMatchInfo, fullName, path);
                if (fnMatchInfo.match)
                {
                    interface.deleteSelf();
                    return;
                }
                if (fnMatchInfo.canMatchChildren)
                {
                    canMatchChildren = true;
                }
            }
        }

        FnAttribute::StringAttribute celAttr = args.getChildByName("CEL");
        if (celAttr.isValid())
        {
            FnGeolibServices::FnGeolibCookInterfaceUtils::MatchesCELInfo info;
            FnGeolibServices::FnGeolibCookInterfaceUtils::matchesCEL(
                info, interface, celAttr);
            if (info.matches)
            {
                interface.deleteSelf();
                return;
            }

            if (info.canMatchChildren)
            {
                canMatchChildren = true;
            }
        }
    }

    static void cook(Foundry::Katana::GeolibCookInterface& interface)
    {
        bool canMatchChildren = false;
        const std::string fullName = interface.getOutputLocationPath();

        FnAttribute::GroupAttribute batchAttr = interface.getOpArg("batch");
        if (batchAttr.isValid())
        {
            const auto numBatches = batchAttr.getNumberOfChildren();
            for (int x = 0; x < numBatches; ++x)
            {
                FnAttribute::GroupAttribute args = batchAttr.getChildByIndex(x);
                apply(interface, fullName, args, canMatchChildren);
            }
        }
        else
        {
            apply(interface, fullName, interface.getOpArg(""),
                  canMatchChildren);
        }

        if (!canMatchChildren)
            interface.stopChildTraversal();
    }
};
DEFINE_GEOLIBOP_PLUGIN(PruneOp)

}  // namespace

void registerPlugins()
{
    REGISTER_PLUGIN(PruneOp, "Prune", 0, 1);
}
