// Copyright (c) 2012 The Foundry Visionmongers Ltd. All Rights Reserved.
#pragma once

#include <cstdint>
#include <limits>
#include <string>
#include <vector>
#include <FnAsset/plugin/FnFileSequence.h>
#include <FnPluginSystem/FnPlugin.h>
#include <FnPluginSystem/FnPluginSystem.h>

#include "SequenceMatching.h"

class FileSeq : public FnKat::FileSequence
{
public:
    FileSeq(std::string prefix,
            std::string suffix,
            int32_t firstFrame,
            int32_t lastFrame,
            size_t padding);

    explicit FileSeq(const std::string& fileSequenceString);
    virtual ~FileSeq() = default;

    FileSeq(const FileSeq& other) = default;
    FileSeq(FileSeq&& other) = default;

    static FnPlugStatus setHost(FnPluginHost* host);
    static FnPluginHost* getHost();

    bool isValid() const override;
    FileSequence* clone() const override;
    void getAsString(std::string& retValue) override;
    void getDirectory(std::string& retValue) override;
    void getPrefix(std::string& retValue) override;
    void getSuffix(std::string& retValue) override;
    unsigned int getPadding() override;
    void getResolvedPath(const int frame, std::string& retValue) override;
    bool hasFrameSet() override;
    bool isFrameInFrameSet(const int frame) override;
    int getFirstFrameInFrameSet() override;
    int getLastFrameInFrameSet() override;
    void getNearestFramesInFrameSet(int frame,
                                    bool* hasLeft,
                                    int* nearestLeft,
                                    bool* hasRight,
                                    int* nearestRight) override;
    void getFrameListFromFrameSet(std::vector<int>& returnList) override;

    static FileSequence* create(const char*);
    static bool isFileSequence(const char*);
    static std::string buildFileSequenceString(const std::string& prefix,
                                               const std::string& suffix,
                                               int padding);
    static FnKat::FileSequenceArray* findSequence(const char** fileList,
                                                  unsigned int fileCount);
    static void flush() {}

private:
    static FnPluginHost* m_host;
    std::string convertAssetIDToFilePath(const std::string& assetID) const;
    std::string _prefix;
    std::string _suffix;
    int32_t _firstFrame{std::numeric_limits<int32_t>::min()};
    int32_t _lastFrame{std::numeric_limits<int32_t>::min()};
    unsigned int _padding{0};
    bool _hasFrameSet{true};
    bool _isValid{true};
    std::string _sequenceStringForm;

    std::string generateStringForm();
};
