# Copyright (c) 2021 The Foundry Visionmongers Ltd. All Rights Reserved.
"""
Module initializes Nuke plug-ins.
"""
import os
import sys

import nuke

import NukeRender

if sys.platform.startswith('win'):
    # In Windows, in the absence of RPATH/RUNPATH, PATH needs to be set.
    scriptPath = os.path.abspath(os.path.realpath(__file__))
    scriptDir = os.path.dirname(scriptPath)
    katanaRoot = os.path.dirname(
        os.path.dirname(os.path.dirname(os.path.dirname(scriptDir))))
    os.environ['PATH'] += os.pathsep + os.path.join(katanaRoot, 'bin')
    os.environ['PATH'] += os.pathsep + os.path.join(scriptDir, 'bin')

nuke.pluginAddPath('./bin')

NukeRender.StartNukeService()
