# Copyright (c) 2021 The Foundry Visionmongers Ltd. All Rights Reserved.
"""
Module contains the main render script used to interact with Nuke.
"""

import sys

import nuke

import NukeRender

if len(sys.argv) != 6:
    print('Usage: NukeBridge.py <nuke script> <render method> <frame> '
          '<KatanaWriter> interactive|script')
    sys.exit(-1)

nukeScript = sys.argv[1]
renderMethod = sys.argv[2]
frame = int(sys.argv[3])
katanaWriterNodeName = sys.argv[4]
interactive = sys.argv[5] == 'interactive'

if nukeScript:
    nuke.scriptOpen(nukeScript)

# Render
NukeRender.SetKatanaWriterNode(katanaWriterNodeName)
NukeRender.SetCurrentFrame(frame)
NukeRender.RenderLoop(renderMethod, interactive)
