"""
NAME: Convert to ShadingGroup
SCOPE: ShadingNodeSubnet

Converts a ShadingNodeSubnet to a ShadingGroup.

"""

import NodegraphAPI

node = globals().get('node')
if node:
    # Copy the child graph.
    graph = NodegraphAPI.BuildNodesXmlIO(node.getChildren())

    # Create the new ShadingGroup
    shadingGroup = NodegraphAPI.CreateNode('ShadingGroup', node.getParent())

    # Move the ShadingGroup to the same position as the node being replaced.
    NodegraphAPI.SetNodePosition(shadingGroup, NodegraphAPI.GetNodePosition(node))

    # Set flags on new node if old node had them. It must be being edited if this
    # script is running, as it runs from the Parameters tab and is node specific.
    viewed = NodegraphAPI.IsNodeViewed(node)
    NodegraphAPI.SetNodeEdited(shadingGroup, True, exclusive=True)
    NodegraphAPI.SetNodeViewed(shadingGroup, viewed, exclusive=True)

    # Remove the old node first so that the pasted nodes retain their names
    node.delete()

    # Paste the nodes into the new ShadingGroup
    KatanaFile.Paste(graph, shadingGroup)

    # Convert position to left-right instead of top-down. This also applies a
    # small scale to move the nodes away from each other.
    for child in shadingGroup.getChildren():
        pos = NodegraphAPI.GetNodePosition(child)
        NodegraphAPI.SetNodePosition(child, (-pos[1] * 2, pos[0]))
