#******************************************************************************
#
#              Copyright (c) 2009 Sony Pictures Imageworks Inc.
#                             All rights reserved.
#
#   This  material  contains  the confidential and  proprietary information
#   of Sony Pictures Imageworks Inc.   and may not be disclosed,  copied or
#   duplicated  in any form,  electronic or hardcopy,  in whole  or in part,
#   without  the express prior written  consent of Sony Pictures Imageworks
#   Inc. This copyright notice does not imply publication.
#
#******************************************************************************
# pylint: disable=undefined-variable

"""
NAME: Renders
ICON: 

Select all Render nodes and frame them

"""

# The following symbols are added when run as shelf buttons:
# exit():      Allows 'error-free' early exit from the script.

foundAny = False
for node in NodegraphAPI.GetAllNodesByType('Render', sortByName=False):
    foundAny = True
    NodegraphAPI.SetNodeSelected(node, isRender)
        
if foundAny:
    nodeGraphTab = UI4.App.Tabs.FindTopTab("Node Graph")
    if nodeGraphTab:
        nodeGraphTab.frameSelection()
else:
    raise Exception("No Render nodes found.")

