#******************************************************************************
#
#              Copyright (c) 2009 Sony Pictures Imageworks Inc.
#                             All rights reserved.
#
#   This  material  contains  the confidential and  proprietary information
#   of Sony Pictures Imageworks Inc.   and may not be disclosed,  copied or
#   duplicated  in any form,  electronic or hardcopy,  in whole  or in part,
#   without  the express prior written  consent of Sony Pictures Imageworks
#   Inc. This copyright notice does not imply publication.
#
#******************************************************************************

"""
NAME: Merge
ICON: Icons/shelfDefault.png

Merge all selected nodes

"""
# pylint: disable=undefined-variable

# The following symbols are added when run as shelf buttons:
# exit():      Allows 'error-free' early exit from the script.

(nodes, parent) = NodegraphAPI.GetAllSelectedNodesAndParent()
merge = NodegraphAPI.CreateNode("Merge", parent)

nodes.sort(key=NodegraphAPI.GetNodePosition)
for n in nodes:
    NodegraphAPI.SetNodeSelected(n, False)
    output = n.getOutputPortByIndex(0)
    if not output:
        continue
    numInputs = merge.getNumInputPorts()
    merge.addInputPort("i")
    input = merge.getInputPortByIndex(numInputs)
    output.connect(input)

DrawingModule.AutoPositionNodes([merge], oldStyle=True)
NodegraphAPI.SetNodeSelected(merge, True)

