#******************************************************************************
#
#              Copyright (c) 2009 Sony Pictures Imageworks Inc.
#                             All rights reserved.
#
#   This  material  contains  the confidential and  proprietary information
#   of Sony Pictures Imageworks Inc.   and may not be disclosed,  copied or
#   duplicated  in any form,  electronic or hardcopy,  in whole  or in part,
#   without  the express prior written  consent of Sony Pictures Imageworks
#   Inc. This copyright notice does not imply publication.
#
#******************************************************************************

"""
NAME: Lighten Material Nodes
ICON: 

Removes unset parameters from Material nodes

"""
# pylint: disable=undefined-variable

for node in NodegraphAPI.GetAllEditedNodes():
    NodegraphAPI.SetNodeEdited(node, False)

CacheManager.flush()

Utils.UndoStack.DisableCapture()

try:
    for node in NodegraphAPI.GetAllNodesByType('Material', sortByName=False):
        if node.isLocked(): continue
        
        node.getParameter('shaders.__lastValue').setValue('', 0)
        
        parametersParam = node.getParameter('shaders.parameters')
        for param in parametersParam.getChildren():
            if param.getName() == "__unused": continue
            if param.getType() != "group": continue
            if not param.getChild('enable'): continue
            if param.getChild('enable').getValue(0): continue
            parametersParam.deleteChild(param)
finally:
    Utils.UndoStack.EnableCapture()

