#******************************************************************************
#
#              Copyright (c) 2009 Sony Pictures Imageworks Inc.
#                             All rights reserved.
#
#   This  material  contains  the confidential and  proprietary information
#   of Sony Pictures Imageworks Inc.   and may not be disclosed,  copied or
#   duplicated  in any form,  electronic or hardcopy,  in whole  or in part,
#   without  the express prior written  consent of Sony Pictures Imageworks
#   Inc. This copyright notice does not imply publication.
#
#******************************************************************************

"""
NAME: Layout
ICON: Icons/network.png

Automatically layout the selected nodes

"""

from PyQt5 import QtWidgets

import NodegraphAPI
from Katana import (
    DrawingModule,
    UI4,
)
# The following symbols are added when run as shelf buttons:
# exit():      Allows 'error-free' early exit from the script.


nodes = NodegraphAPI.GetAllSelectedNodes()
result = QtWidgets.QMessageBox.AcceptRole
if len(nodes) > 8:
    result = UI4.Widgets.MessageBox.Question("Auto layout %d nodes" % len(nodes),
                "You are attempting to layout more than a few nodes.\n"
                "This can be a potentially long and slow process, you\n"
                "may want to save your file first.\n\n"
                "Are you sure you want to continue layout of many nodes?",
                acceptText="Layout Nodes", cancelText="Cancel")
if result == QtWidgets.QMessageBox.AcceptRole:
    DrawingModule.AutoPositionNodes(nodes)

