#******************************************************************************
#
#              Copyright (c) 2009 Sony Pictures Imageworks Inc.
#                             All rights reserved.
#
#   This  material  contains  the confidential and  proprietary information
#   of Sony Pictures Imageworks Inc.   and may not be disclosed,  copied or
#   duplicated  in any form,  electronic or hardcopy,  in whole  or in part,
#   without  the express prior written  consent of Sony Pictures Imageworks
#   Inc. This copyright notice does not imply publication.
#
#******************************************************************************

"""
NAME: Duplicate
ICON: icon.png

Duplicate seleted nodes and input connections.

"""
# pylint: disable=undefined-variable

# The following symbols are added when run as shelf buttons:
# exit():      Allows 'error-free' early exit from the script.


def FloatNodes(nodeList):
    NodegraphPanel = UI4.App.Tabs.FindTopTab("Node Graph", alsoRaise=True)
    if NodegraphPanel:
        for n in NodegraphAPI.GetAllSelectedNodes():
            NodegraphAPI.SetNodeSelected(n, False)
        
        for n in nodeList:
            NodegraphAPI.SetNodeFloating(n, True)
        NodegraphPanel.prepareFloatingLayerWithPasteBounds(nodeList)
        NodegraphPanel.enableFloatingLayer()


# Get and copy the nodes
nodes, parent  = NodegraphAPI.GetAllSelectedNodesAndParent()
element = NodegraphAPI.BuildNodesXmlIO(nodes, forcePersistant=True)
newNodes = KatanaFile.Paste(element, parent)
del element

for (old, new) in zip(nodes, newNodes):
    # Offset positions
    pos = NodegraphAPI.GetNodePosition(old)
    NodegraphAPI.SetNodePosition(new, (pos[0]+80, pos[1]-40))
    
    # Connect unused inputs
    for oldPort in old.getInputPorts():
        newPort = new.getInputPort(oldPort.getName())
        if newPort and not newPort.getConnectedPorts():
            for otherPort in oldPort.getConnectedPorts():
                otherPort.connect(newPort)

# Only float nodes with the same parent
nodesToFloat = [n for n in newNodes if n.getParent() == parent]
FloatNodes(nodesToFloat)
