#******************************************************************************
#
#              Copyright (c) 2009 Sony Pictures Imageworks Inc.
#                             All rights reserved.
#
#   This  material  contains  the confidential and  proprietary information
#   of Sony Pictures Imageworks Inc.   and may not be disclosed,  copied or
#   duplicated  in any form,  electronic or hardcopy,  in whole  or in part,
#   without  the express prior written  consent of Sony Pictures Imageworks
#   Inc. This copyright notice does not imply publication.
#
#******************************************************************************

"""
NAME: Color Nodes
ICON: icon.png

This will color all nodes in the current scene according to the current
Katana version's rules.

"""

# The following symbols are added when run as shelf buttons:
# exit():      Allows 'error-free' early exit from the script.
# console_print(message, raisePanel = False):
#              If the Python Console exists, print the message to it.
#              Otherwise, print the message to the shell. If raisePanel
#              is passed as True, the panel will be raised to the front.


import NodegraphAPI
import Nodes2DAPI
from Katana import DrawingModule
from Nodes2DAPI import NodeColorDelegate

delegate = NodeColorDelegate.NodeColorDelegate()

for node in NodegraphAPI.GetAllNodes(sortByName=False):
    color = delegate.getPreferredNodeColor(node.getType(), node.getName())
    if color is not None:
        NodegraphAPI.SetNodeShapeAttr( node,  "colorr", color[0] )
        NodegraphAPI.SetNodeShapeAttr( node,  "colorg", color[1] )
        NodegraphAPI.SetNodeShapeAttr( node,  "colorb", color[2] )
        DrawingModule.SetCustomNodeColor( node, color[0], color[1], color[2])
