#version 400

layout (location = 0) in vec3 inPosition;
layout (location = 1) in vec3 inNormal;
layout (location = 2) in vec2 inUV;

out vec3 position;
out vec3 normal;
out vec2 uv;

uniform dmat4 worldMatrix;
uniform dmat4 viewMatrix;
uniform dmat4 projectionMatrix;

void main()
{
    dmat4 worldViewMatrix = viewMatrix * worldMatrix;
    normal = vec4(worldViewMatrix * dvec4(inNormal, 0.0)).xyz;
    position = inPosition.xyz;

    dmat4 transformMatrix = projectionMatrix * worldViewMatrix;
    gl_Position = vec4(transformMatrix * dvec4(inPosition, 1.0));

    uv = inUV;
}
