#version 400

layout(lines) in;
layout(line_strip, max_vertices = 2) out;

uniform vec2 viewportSize;

noperspective out float texCoord;

void main()
{
    // In this geometry shader we want to provide the fragment shader with
    // the length of the line (`texCoord`). That will allow us to render the
    // line in a similar way to what `glLineStipple` did before it became
    // deprecated.

    // We take a line and compute its screen space length in pixels.
    vec2 winPos0 =
        viewportSize.xy * gl_in[0].gl_Position.xy / gl_in[0].gl_Position.w;
    vec2 winPos1 =
        viewportSize.xy * gl_in[1].gl_Position.xy / gl_in[1].gl_Position.w;

    // The line is then passed-through, along side with its length.
    gl_Position = gl_in[0].gl_Position;
    texCoord = 0.0;
    EmitVertex();
    gl_Position = gl_in[1].gl_Position;
    texCoord = 0.5 * length(winPos1 - winPos0);
    EmitVertex();
}
