#version 400

in vec3 position;
in vec3 normal;
in vec2 uv;

layout (location = 0) out vec4 fragColor;

// Line stipple.
noperspective in float texCoord;
uniform int pattern;
uniform float factor;

uniform sampler2D tex;

uniform vec4 color;
uniform int handleId;
uniform int handlePriority;
uniform int mode;

const uint Picking      = 0;
const uint FlatShading  = 1;
const uint Shading      = 2;
const uint LineStripple = 3;
const uint Textured     = 4;

void main()
{
    if (mode == Picking) // picking
    {
        fragColor = vec4(handleId / 255.0, handlePriority / 255.0, 0.0, 0.0);
    }
    else if (mode == FlatShading) // flat shading
    {
        fragColor = color;
    }
    else if (mode == Shading) // 3d shading
    {
        vec3 lightPos = vec3(0.0, 0.0, 10.0);

        vec3 N = normalize(normal);
        vec3 L = normalize(lightPos - position);
        float lambert = max(dot(N, L), 0.0);

        vec3 ambient = color.rgb * 0.4;
        vec3 diffuse = color.rgb * 0.8;

        fragColor.rgb = ambient + (diffuse * lambert);
        fragColor.a = color.a;
    }
    else if (mode == LineStripple)  // Line stipple.
    {
        // Emulates `glLineStipple`. `texCoord` provided by geometry shader.
        uint bit = uint(round(texCoord / factor)) & 31U;
        if ((pattern & (1U << bit)) == 0U)
        {
            discard;
        }

        fragColor = color;
    }
    else if (mode == Textured)
    {
        fragColor = texture(tex, uv);
    }
}
