#version 420

layout( location = 0 ) in vec3 VertexPosition;

out vec3 Color;

uniform dmat4 WorldMatrix;
uniform dmat4 ViewMatrix;
uniform dmat4 ProjectionMatrix;
uniform float PointSize;

void main()
{
    gl_PointSize = PointSize;
    dmat4 xform = ProjectionMatrix * ViewMatrix * WorldMatrix;
    gl_Position =  vec4(xform * dvec4(VertexPosition, 1.0f));
}
