#version 400

layout (location = 0) in vec3 VertexPosition;

uniform vec4 inColor;
uniform float inOffsetMultip;
uniform dmat4 ViewMatrix;
uniform dmat4 ProjectionMatrix;

out vec4 Color;
out float offsetMultip;

void main()
{

    dmat4 xform = ProjectionMatrix * ViewMatrix;
    gl_Position = vec4(xform * vec4(VertexPosition, 1.0));
    Color = inColor;
    offsetMultip = inOffsetMultip;
}
