#version 400

layout(location = 0) out vec4 FragColor;

uniform sampler2D inputTexture;

float easeFunc(float x)
{
    return 1 - (1 - x) * (1 - x);
}

void main()
{
    ivec2 center = ivec2(gl_FragCoord);
    vec4 centerTexel = texelFetch(inputTexture, center, 0);

    int kWindowSide = 2;

    int mismatches = 0;
    for (int i = -kWindowSide; i <= kWindowSide; ++i)
    {
        for (int j = -kWindowSide; j <= kWindowSide; ++j)
        {
            ivec2 pos = center + ivec2(i, j);
            vec4 texel = texelFetch(inputTexture, pos, 0);

            mismatches += int(centerTexel != texel);
        }
    }

    int kMaxMismatches = kWindowSide * kWindowSide * 4;

    float color = float(mismatches != 0);
    float x = float(mismatches) / kMaxMismatches;
    float alpha = easeFunc(x);
    FragColor = vec4(color, color, color, alpha);
}
