#version 400

layout (location = 0) in vec3 VertexPosition;
layout (location = 1) in vec2 VertexUV;

out vec2 UV;
out vec4 Color;

uniform dmat4 WorldMatrix;
uniform dmat4 ViewMatrix;
uniform dmat4 ProjectionMatrix;
uniform vec4 inColor;

void main()
{
    dmat4 xform = ProjectionMatrix * ViewMatrix * WorldMatrix;
    gl_Position = vec4(xform * vec4(VertexPosition, 1.0f));
    UV = VertexUV;
    Color = inColor;
}
