#version 400

layout (location = 0) in vec3 VertexPosition;
layout (location = 1) in vec2 VertexUV;

out vec2 UV;

uniform dmat4 WorldMatrix;
uniform dmat4 ViewMatrix;
uniform dmat4 ProjectionMatrix;
uniform vec2 UVoffset = vec2(0.0f, 0.0f);
uniform vec2 UVscale = vec2(1.0f, 1.0f);

void main()
{
    gl_Position = vec4(ProjectionMatrix * ViewMatrix * WorldMatrix
                       * dvec4(VertexPosition, 1.0f));
    UV = (UVoffset + VertexUV) * UVscale;
}
