// Copyright (c) 2017 The Foundry Visionmongers Ltd. All Rights Reserved.

#include <FnViewer/plugin/FnOptionIdGenerator.h>

#include <FnPluginManager/FnPluginManager.h>

namespace Foundry
{
namespace Katana
{
namespace ViewerAPI
{

FnPlugStatus OptionIdGenerator::setHost(FnPluginHost *host)
{
    if (host)
    {
        _host = host;
        _optionIdGeneratorSuite = reinterpret_cast<const FnOptionIdGeneratorHostSuite_v1*>(
            host->getSuite("OptionIdGeneratorHost", 1));
        if (_optionIdGeneratorSuite)
        {
            return FnPluginStatusOK;
        }
    }
    return FnPluginStatusError;
}

const FnOptionIdGeneratorHostSuite_v1* OptionIdGenerator::getSuite()
{
    if (_optionIdGeneratorSuite)
        return _optionIdGeneratorSuite;

    setHost(_host);
    return _optionIdGeneratorSuite;
}

void OptionIdGenerator::setSuite(const FnOptionIdGeneratorHostSuite_v1 *suite)
{
    if (suite)
    {
        _optionIdGeneratorSuite = suite;
    }
}

OptionIdGenerator::value_type OptionIdGenerator::GenerateId(const char* text)
{
    if (!_handle)
        getHandle();

    return getSuite()->GenerateId(_handle, text);
}

const char* OptionIdGenerator::LookUpOptionId(OptionIdGenerator::value_type hash)
{
    if (!_handle)
        getHandle();

    return getSuite()->LookUpOptionId(_handle, hash);
}

FnOptionIdGeneratorHostHandle OptionIdGenerator::_handle = 0x0;
const FnOptionIdGeneratorHostSuite_v1 *OptionIdGenerator::_optionIdGeneratorSuite = 0x0;
FnPluginHost *OptionIdGenerator::_host = 0x0;



} // ViewerAPI
} // Katana
} // Foundry
