// Copyright (c) 2016 The Foundry Visionmongers Ltd. All Rights Reserved.

#include <FnViewer/plugin/FnEventWrapper.h>

using Foundry::Katana::ViewerAPI::FnEventWrapper;

FnEventWrapper::FnEventWrapper()
{

}

FnEventWrapper::FnEventWrapper(const FnAttribute::GroupAttribute& attr)
    : m_data(attr)
{

}

FnEventWrapper::FnEventWrapper(const FnEventWrapper& other)
{
    m_data = other.m_data;
}

FnEventWrapper::~FnEventWrapper()
{

}

std::string FnEventWrapper::getType() const
{
    if(m_data.isValid())
    {
        FnAttribute::StringAttribute typeAttr = m_data.getChildByName("type");
        if(typeAttr.isValid())
        {
            return typeAttr.getValue("", false);
        }
    }
    return "";
}

FnAttribute::Hash FnEventWrapper::getTypeHash() const
{
    if (m_data.isValid())
    {
        FnAttribute::StringAttribute typeAttr = m_data.getChildByName("type");
        if (typeAttr.isValid())
        {
            return typeAttr.getHash();
        }
    }
    return FnAttribute::Hash();
}

FnAttribute::GroupAttribute FnEventWrapper::getData() const
{
    if(m_data.isValid())
    {
        return m_data.getChildByName("data");
    }
    return FnAttribute::GroupAttribute();
}

FnAttributeHandle FnEventWrapper::getHandle() const
{
    return m_data.getHandle();
}

FnAttributeHandle FnEventWrapper::getRetainedHandle() const
{
    return m_data.getRetainedHandle();
}
