// Copyright (c) 2012 The Foundry Visionmongers Ltd. All Rights Reserved.

#include "FnDisplayDriver/KatanaPipeSingleton.h"

#include <cstdlib>
#include <iostream>
#include <sstream>
#include <string>

#include <FnDisplayDriver/FnDisplayDriver.h>

// Initialise the pipe singleton...
Foundry::Katana::KatanaPipe* Foundry::Katana::PipeSingleton::_pipe = NULL;

namespace
{
// Default is taken from a value defined in FnDisplayDriverSuite.h so it can
// be shared between client & host implementations
const size_t kDefaultMaxQueueSize = kFnKatDefaultMaxQueueSize;
}  // anonymous namespace

namespace Foundry
{
namespace Katana
{
KatanaPipe* PipeSingleton::Instance(const std::string& hostName,
                                    unsigned int portNumber,
                                    const std::string& katanaPath)
{
    if (!_pipe)
    {
        // Bootstrap Display Driver host
        std::string path(katanaPath);
        if (path.empty())
        {
            const char* katanaRootEnvVar = std::getenv("KATANA_ROOT");
            if (katanaRootEnvVar == NULL)
            {
                std::cerr << "[KatanaPipe] WARNING: "
                             "KATANA_ROOT environment variable not set."
                          << std::endl;
                return NULL;
            }
            path.assign(katanaRootEnvVar);
        }

        if (!FNDISPLAYDRIVER_NAMESPACE::FnDisplayDriver::Bootstrap(path))
        {
            return _pipe;
        }

        // Initialize KatanaPipe instance
        _pipe = new KatanaPipe(hostName, portNumber, GetQueueSize());
    }

    return _pipe;
}

size_t PipeSingleton::GetQueueSize()
{
    size_t maxQueueSize = kDefaultMaxQueueSize;

    const char* queueSizeEnvVar = std::getenv("KATANA_PIPE_MAX_QUEUE_SIZE");
    if (queueSizeEnvVar != NULL)
    {
        // TODO(DH): Replace with std::stoul when we transition plugin_apis
        // to C++11
        std::stringstream ss(queueSizeEnvVar);
        ss << queueSizeEnvVar;
        int64_t parsedQueueSize = 0;
        ss >> parsedQueueSize;

        if (parsedQueueSize == 0 || parsedQueueSize < 0)
        {
            std::cerr << "[KatanaPipe] WARNING: "
                         "Unable to parse KATANA_PIPE_MAX_QUEUE_SIZE = "
                      << queueSizeEnvVar << std::endl;
        }
        else
        {
            maxQueueSize = static_cast<size_t>(parsedQueueSize);
        }
    }
    return maxQueueSize;
}

}  // namespace Katana
}  // namespace Foundry
