#include <cassert>
#include <iostream>

#include <FnConfig/FnConfig.h>

FNCONFIG_NAMESPACE_ENTER
{

Config::Config() {}
Config::~Config() {}

bool Config::has(const std::string& key)
{
    return getSuite()->has(key.c_str());
}

std::string Config::get(const std::string& key)
{
    const char * value = getSuite()->get(key.c_str());
    return ((value == nullptr) ? std::string() : std::string(value));
}

void Config::exportConfiguration(
    std::map<std::string, std::string>& exportedConfig)
{
    int64_t numKeysAndValues{0};
    char** configArray = getSuite()->exportConfiguration(&numKeysAndValues);

    for (int c = 0; c < numKeysAndValues; c += 2)
    {
        exportedConfig[configArray[c]] = configArray[c + 1];
        delete[] configArray[c];
        delete[] configArray[c + 1];
    }
    delete[] configArray;
}

const FnConfigHostSuite_v1* Config::getSuite()
{
    assert(_configSuite);
    return _configSuite;
}

FnPluginStatus Config::setHost(FnPluginHost* host)
{
    if (host)
    {
        _configSuite = (FnConfigHostSuite_v1*)(host->getSuite("Config", 1));
        if (_configSuite)
        {
            return FnPluginStatusOK;
        }
    }
    return FnPluginStatusError;
}

const FnConfigHostSuite_v1* Config::_configSuite = nullptr;

}
FNCONFIG_NAMESPACE_EXIT

