// Copyright (c) 2016 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef DRAWINGHELPERS_H_
#define DRAWINGHELPERS_H_

#include <GL/glew.h>
#include <FnLogging/FnLogging.h>

#include <cmath>
#include <iostream>
#include <string>

#if defined(WIN32)
#pragma warning (disable: 4275)
#endif

#if defined(WIN32)
#pragma warning (default: 4275)
#endif

namespace Foundry
{
namespace Katana
{
namespace ViewerUtils
{

/**
 *  This header contains helper functions related with math and drawing
 *  features. If this header is used, then the GLEW library needs to be linked
 *  too.
 */

static inline double toRadians(double angleDegree)
{
    return angleDegree * M_PI / 180.0;
}

static inline double toDegrees(double radians)
{
    return radians * (180.0 / M_PI);
}

inline bool _initializeGlew(FnKat::FnLogging::FnLog& _fnLog)
{
    const GLenum err = glewInit();
    if(err != GLEW_OK)
    {
        std::string errorMsg("Critical error in glewInit(): ");
        errorMsg += (const char*)glewGetErrorString(err);
        FnLogError(errorMsg.c_str());
        return false;
    }
    return true;
}

#define GLEW_INIT() Foundry::Katana::ViewerUtils::_initializeGlew(_fnLog)

} // ViewerUtils
} // Katana
} // Foundry

#endif /* DRAWINGHELPERS_H_ */
