// Copyright (c) 2016 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FNVIEWER_FNVIEWPORTSUITE_H
#define FNVIEWER_FNVIEWPORTSUITE_H

extern "C"
{
    typedef struct FnViewportPluginStruct* FnViewportPluginHandle;
    typedef struct FnViewportHostStruct* FnViewportHostHandle;

    typedef struct FnViewerDelegatePluginStruct* FnViewerDelegatePluginHandle;
    typedef struct FnViewerDelegateHostStruct* FnViewerDelegateHostHandle;

    // Forward declarations
    struct FnViewerDelegatePluginSuite_v3;
    struct FnViewportLayerPluginSuite_v2;
    struct FnViewportCameraPluginSuite_v2;
    struct FnManipulatorPluginSuite_v1;

    #include <FnAttribute/suite/FnAttributeSuite.h>
    #include <FnGeolib/suite/FnGeolibRuntimeSuite.h>

    #include "FnViewerDelegateSuite.h"
    #include "FnViewportLayerSuite.h"
    #include "FnViewportCameraSuite.h"
    #include "FnManipulatorSuite.h"

    #define FnViewportPluginSuite_version 2
    #define FnViewportHostSuite_version 3

    struct FnViewportPluginSuite_v2
    {
        FnViewportPluginHandle (*create)(FnViewportHostHandle hostHandle);

        void (*destroy)(FnViewportPluginHandle handle);

        void (*setup)(FnViewportPluginHandle handle);

        void (*cleanup)(FnViewportPluginHandle handle);

        bool (*event)( FnViewportPluginHandle handle,
            FnAttributeHandle eventAttrHandle);

        void (*draw)(FnViewportPluginHandle handle);

        void (*resize)( FnViewportPluginHandle handle,
            unsigned int width, unsigned int height);

        void (*hover)( FnViewportPluginHandle handle, uint8_t isHovering,
            int x, int y);

        void (*setOption)(
            FnViewportPluginHandle handle, uint64_t optionId,
            FnAttributeHandle attr);

        FnAttributeHandle (*getOption)(
            FnViewportPluginHandle handle, uint64_t optionId);

        void (*freeze)(FnViewportPluginHandle handle);

        void (*thaw)(FnViewportPluginHandle handle);

        void (*pickerDraw)(FnViewportPluginHandle handle,
            unsigned int x, unsigned int y,
            unsigned int w, unsigned int h,
            FnAttributeHandle ignoreAttrHandle);

        int (*customPick)(FnViewportPluginHandle handle,
            unsigned int x, unsigned int y,
            unsigned int w, unsigned int h,
            int deepPicking,
            FnAttributeHandle& pickedObjectsAttrHandle,
            float* singlePointDepth);
    };

    struct FnViewportHostSuite_v3
    {
        const char* (*getName)(FnViewportHostHandle handle);

        void(*getViewerDelegate)(
            FnViewportHostHandle handle,
            FnViewerDelegateHostHandle* viewerDelegateHostHandle,
            FnViewerDelegatePluginHandle* viewerDelegatePluginHandle,
            FnViewerDelegatePluginSuite_v3** viewerDelegatePluginSuite);

        void(*getActiveCamera)(
            FnViewportHostHandle handle,
            FnViewportCameraHostHandle* viewportCameraHostHandle,
            FnViewportCameraPluginHandle* viewportCameraPluginHandle,
            FnViewportCameraPluginSuite_v2** viewportCameraPluginSuite);

        void(*addCamera)(
            FnViewportHostHandle handle,
            const char* pluginName,
            const char* name,
            FnViewportCameraHostHandle* viewportCameraHostHandle,
            FnViewportCameraPluginHandle* viewportCameraPluginHandle,
            FnViewportCameraPluginSuite_v2** viewportCameraPluginSuite);

        void(*removeCamera)(
            FnViewportHostHandle handle,
            FnViewportCameraHostHandle camera);

        void(*setActiveCamera)(
            FnViewportHostHandle handle,
            FnViewportCameraHostHandle camera);

        void(*getCameraByName)(
            FnViewportHostHandle handle, const char* name,
            FnViewportCameraHostHandle* viewportCameraHostHandle,
            FnViewportCameraPluginHandle* viewportCameraPluginHandle,
            FnViewportCameraPluginSuite_v2** viewportCameraPluginSuite);

        void(*getCameraByIndex)(
            FnViewportHostHandle handle, unsigned int index,
            FnViewportCameraHostHandle* viewportCameraHostHandle,
            FnViewportCameraPluginHandle* viewportCameraPluginHandle,
            FnViewportCameraPluginSuite_v2** viewportCameraPluginSuite);

        void(*removeCameraByName)(FnViewportHostHandle handle,
            const char* name);

        void(*removeCameraByIndex)(FnViewportHostHandle handle,
            unsigned int index);

        int(*getNumberOfCameras)(FnViewportHostHandle handle);

        const char* (*getCameraName)(FnViewportHostHandle handle,
            unsigned int index);

        int(*getCameraIndex)(FnViewportHostHandle handle,
            const char* name);


        bool(*event)(FnViewportHostHandle handle,
            FnAttributeHandle eventAttrHandle);

        void(*draw)(FnViewportHostHandle handle);

        void(*resize)(FnViewportHostHandle handle,
            unsigned int width, unsigned int height);

        unsigned int(*getWidth)(FnViewportHostHandle handle);

        unsigned int(*getHeight)(FnViewportHostHandle handle);

        int(*isDirty)(FnViewportHostHandle handle);

        void(*setDirty)(FnViewportHostHandle handle, int dirty);

        void(*addLayer)(
            FnViewportHostHandle handle,
            const char* pluginName, const char* name,
            FnViewportLayerHostHandle* viewportLayerHostHandle,
            FnViewportLayerPluginHandle* viewportLayerPluginHandle,
            FnViewportLayerPluginSuite_v2** viewportLayerPluginSuite);

        void(*insertLayer)(
            FnViewportHostHandle handle, const char* pluginName,
            const char* name, unsigned int index,
            FnViewportLayerHostHandle* viewportLayerHostHandle,
            FnViewportLayerPluginHandle* viewportLayerPluginHandle,
            FnViewportLayerPluginSuite_v2** viewportLayerPluginSuite);

        void(*getLayerByName)(
            FnViewportHostHandle handle, const char* name,
            FnViewportLayerHostHandle* viewportLayerHostHandle,
            FnViewportLayerPluginHandle* viewportLayerPluginHandle,
            FnViewportLayerPluginSuite_v2** viewportLayerPluginSuite);

        void(*getLayerByIndex)(
            FnViewportHostHandle handle, unsigned int index,
            FnViewportLayerHostHandle* viewportLayerHostHandle,
            FnViewportLayerPluginHandle* viewportLayerPluginHandle,
            FnViewportLayerPluginSuite_v2** viewportLayerPluginSuite);

        void(*removeLayerByName)(FnViewportHostHandle handle,
            const char* name);

        void(*removeLayerByIndex)(FnViewportHostHandle handle,
            unsigned int index);

        int(*getNumberOfLayers)(FnViewportHostHandle handle);

        const char* (*getLayerName)(FnViewportHostHandle handle,
            unsigned int index);

        int(*getLayerIndex)(FnViewportHostHandle handle,
            const char* name);

        const double* (*getViewMatrix)(FnViewportHostHandle handle);

        const double* (*getProjectionMatrix)(FnViewportHostHandle handle);
        void(*activateManipulator)(FnViewportHostHandle handle,
            const char* name, FnAttributeHandle locationPathsAttr);

        void(*deactivateManipulator)(FnViewportHostHandle handle,
            const char* name);

        void(*deactivateAllManipulators)(FnViewportHostHandle handle);

        unsigned int(*getNumberOfActiveManipulators)(
            FnViewportHostHandle handle);

        void(*getActiveManipulatorByIndex)(
            FnViewportHostHandle handle, unsigned int index,
            FnManipulatorHostHandle* manipulatorHostHandle,
            FnManipulatorPluginHandle* manipulatorPluginHandle,
            FnManipulatorPluginSuite_v1** manipulatorPluginSuite);

        void(*getActiveManipulatorByName)(
            FnViewportHostHandle handle, const char* pluginName,
            FnManipulatorHostHandle* manipulatorHostHandle,
            FnManipulatorPluginHandle* manipulatorPluginHandle,
            FnManipulatorPluginSuite_v1** manipulatorPluginSuite);

        /// DEPRECATED: this function will be removed in future versions
        int(*detectGLContext)(FnViewportHostHandle handle);

        int(*makeGLContextCurrent)(FnViewportHostHandle handle);

        int(*doneGLContextCurrent)(FnViewportHostHandle handle);

        int(*isGLContextCurrent)(FnViewportHostHandle handle);

        void(*enableCap)(FnViewportHostHandle handle, uint32_t cap);
        void(*disableCap)(FnViewportHostHandle handle, uint32_t cap);

        uint64_t (*addPickableObject)(FnViewportHostHandle handle,
            FnAttributeHandle attrHandle);

        FnAttributeHandle (*pick)(FnViewportHostHandle handle,
            unsigned int x, unsigned int y,
            unsigned int w, unsigned int h,
            int deepPicking,
            float* singlePointDepth);

        void (*setViewFrozen)(FnViewportHostHandle handle, int isViewFrozen);
        int (*isViewFrozen)(FnViewportHostHandle handle);
        void (*setPanAndZoomActive)(FnViewportHostHandle handle, int active);
        int (*isPanAndZoomActive)(FnViewportHostHandle handle);

        /// DEPRECATED: This function will be removed in future versions.
        int (*initGLContext)(FnViewportHostHandle handle);

        unsigned int (*getDefaultFramebufferObject)(
            FnViewportHostHandle handle);

        float (*getHorizontalOffset)(FnViewportHostHandle handle);
        float (*getVerticalOffset)(FnViewportHostHandle handle);
        float (*getZoom)(FnViewportHostHandle handle);
    };
}

#endif //FNVIEWER_FNVIEWPORTSUITE_H
