// Copyright (c) 2016 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FNVIEWER_FNVIEWPORTLAYERSUITE_H
#define FNVIEWER_FNVIEWPORTLAYERSUITE_H

extern "C"
{
    typedef struct FnViewportLayerPluginStruct* FnViewportLayerPluginHandle;
    typedef struct FnViewportLayerHostStruct* FnViewportLayerHostHandle;

    struct FnViewportPluginSuite_v2;  // Forward declaration

    #include <FnAttribute/suite/FnAttributeSuite.h>
    #include <FnGeolib/suite/FnGeolibRuntimeSuite.h>

    #include "FnViewportSuite.h"

    #define FnViewportLayerPluginSuite_version 2
    #define FnViewportLayerHostSuite_version 2

    struct FnViewportLayerPluginSuite_v2
    {
        FnViewportLayerPluginHandle (*create)(
            FnViewportLayerHostHandle hostHandle);

        void (*destroy)(FnViewportLayerPluginHandle handle);

        void (*setup)(FnViewportLayerPluginHandle handle);

        void (*cleanup)(FnViewportLayerPluginHandle handle);

        int (*event)(FnViewportLayerPluginHandle handle,
            FnAttributeHandle eventAttrHandle);

        void (*draw)(FnViewportLayerPluginHandle handle);

        void (*resize)( FnViewportLayerPluginHandle handle,
            unsigned int width, unsigned int height);

        void (*hover)( FnViewportLayerPluginHandle handle, uint8_t isHovering,
            int x, int y);

        void (*freeze)(FnViewportLayerPluginHandle handle);

        void (*thaw)(FnViewportLayerPluginHandle handle);

        void (*setOption)( FnViewportLayerPluginHandle handle,
            uint64_t optionId, FnAttributeHandle attr);

        FnAttributeHandle (*getOption)( FnViewportLayerPluginHandle handle,
            uint64_t optionId);

        void (*pickerDraw)(FnViewportLayerPluginHandle handle,
            unsigned int x, unsigned int y,
            unsigned int w, unsigned int h,
            FnAttributeHandle ignoreAttrHandle);

        int (*usesPickingOnHover)(FnViewportLayerPluginHandle handle);

        int (*customPick)(FnViewportLayerPluginHandle handle,
            unsigned int x, unsigned int y,
            unsigned int w, unsigned int h,
            int deepPicking,
            FnAttributeHandle& pickedObjectsAttrHandle,
            float* singlePointDepth);
    };

    struct FnViewportLayerHostSuite_v2
    {
        void (*getViewport)(
            FnViewportLayerHostHandle handle,
            FnViewportHostHandle* viewportHostHandle,
            FnViewportPluginHandle* viewportPluginHandle,
            FnViewportPluginSuite_v2** viewportPluginSuite);

        int (*event)(FnViewportLayerHostHandle handle,
            FnAttributeHandle eventAttrHandle);

        void (*draw)(FnViewportLayerHostHandle handle);

        void (*hover)( FnViewportLayerHostHandle handle, uint8_t isHovering,
            int x, int y);

        uint64_t (*addPickableObject)(FnViewportLayerHostHandle handle,
            FnAttributeHandle attrHandle);

        FnAttributeHandle (*pick)(FnViewportLayerHostHandle handle,
            unsigned int x, unsigned int y,
            unsigned int w, unsigned int h,
            int deepPicking,
            float* singlePointDepth);
    };
}

#endif //FNVIEWER_FNVIEWPORTLAYERSUITE_H
