// Copyright (c) 2017 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FNVIEWER_FNVIEWPORTCAMERASUITE_H
#define FNVIEWER_FNVIEWPORTCAMERASUITE_H

extern "C"
{
    typedef struct FnViewportCameraPluginStruct* FnViewportCameraPluginHandle;
    typedef struct FnViewportCameraHostStruct* FnViewportCameraHostHandle;

    struct FnViewportPluginSuite_v2;  // Forward declaration

    #include <FnAttribute/suite/FnAttributeSuite.h>
    #include <FnGeolib/suite/FnGeolibRuntimeSuite.h>

    #include "FnViewportSuite.h"

    #define FnViewportCameraPluginSuite_version 2
    #define FnViewportCameraHostSuite_version 2

    // Client Suites:

    struct FnViewportCameraPluginSuite_v1 // old version
    {
        FnViewportCameraPluginHandle (*create)(
            FnViewportCameraHostHandle hostHandle);

        void (*destroy)(FnViewportCameraPluginHandle handle);
        int (*getCameraTypeID)(FnViewportCameraPluginHandle handle);
        void (*setViewportDimensions)(FnViewportCameraPluginHandle handle,
            unsigned int width, unsigned int height);
        void (*setOption)(FnViewportCameraPluginHandle handle, uint64_t optionId,
            FnAttributeHandle attr);
        FnAttributeHandle (*getOption)(FnViewportCameraPluginHandle handle,
            uint64_t optionId);
        void (*translate)(FnViewportCameraPluginHandle handle, double x,
            double y, double z);
        void (*rotate)(FnViewportCameraPluginHandle handle, double x, double y,
            double z);
        void (*setup)(FnViewportCameraPluginHandle handle, FnAttributeHandle attr);
        FnAttributeHandle (*asAttribute)(FnViewportCameraPluginHandle handle);
        bool (*getPointOnPlane)(FnViewportCameraPluginHandle handle, int x, int y,
            const double originX, const double originY, const double originZ,
            const double normalX, const double normalY, const double normalZ,
            double* intersectionX, double* intersectionY, double* intersectionZ);
        void (*projectObjectIntoWindow)(FnViewportCameraPluginHandle handle,
            const double objectX, const double objectY, const double objectZ,
            double* windowX, double* windowY, double* windowZ);
        void (*projectWindowIntoObject)(FnViewportCameraPluginHandle handle,
            const double windowX, const double windowY, const double windowZ,
            double* objectX, double* objectY, double* objectZ);
    };

    struct FnViewportCameraPluginSuite_v2
    {
        FnViewportCameraPluginHandle (*create)(
            FnViewportCameraHostHandle hostHandle);

        void (*destroy)(FnViewportCameraPluginHandle handle);
        int (*getCameraTypeID)(FnViewportCameraPluginHandle handle);
        void (*setViewportDimensions)(FnViewportCameraPluginHandle handle,
            unsigned int width, unsigned int height);
        void (*setOption)(FnViewportCameraPluginHandle handle, uint64_t optionId,
            FnAttributeHandle attr);
        FnAttributeHandle (*getOption)(FnViewportCameraPluginHandle handle,
            uint64_t optionId);
        void (*translate)(FnViewportCameraPluginHandle handle, double x,
            double y, double z);
        void (*rotate)(FnViewportCameraPluginHandle handle, double x, double y,
            double z);
        void (*setup)(FnViewportCameraPluginHandle handle, FnAttributeHandle attr);
        FnAttributeHandle (*asAttribute)(FnViewportCameraPluginHandle handle);
        bool (*getPointOnPlane)(FnViewportCameraPluginHandle handle, int x, int y,
            const double originX, const double originY, const double originZ,
            const double normalX, const double normalY, const double normalZ,
            double* intersectionX, double* intersectionY, double* intersectionZ);
        void (*projectObjectIntoWindow)(FnViewportCameraPluginHandle handle,
            const double objectX, const double objectY, const double objectZ,
            double* windowX, double* windowY, double* windowZ);
        void (*projectWindowIntoObject)(FnViewportCameraPluginHandle handle,
            const double windowX, const double windowY, const double windowZ,
            double* objectX, double* objectY, double* objectZ);
        // New functions in v2:
        void (*startInteraction)(FnViewportCameraPluginHandle handle);
        void (*endInteraction)(FnViewportCameraPluginHandle handle);

        void(*setDirty)(FnViewportCameraPluginHandle handle,
            int32_t dirtyBits);

        void (*getRay)(FnViewportCameraPluginHandle handle,
            int x, int y,
            double* posX, double* posY, double* posZ,
            double* dirX, double* dirY, double* dirZ);
    };

    // Host Suite:

    struct FnViewportCameraHostSuite_v1
    {

        const double* (*getViewMatrix)(FnViewportCameraHostHandle handle);
        void (*setViewMatrix)(FnViewportCameraHostHandle handle,
            const double* matrix);

        const double* (*getProjectionMatrix)(FnViewportCameraHostHandle handle);
        void (*setProjectionMatrix)(FnViewportCameraHostHandle handle,
            const double* matrix);

        double (*getCenterOfInterest)(FnViewportCameraHostHandle handle);
        void (*setCenterOfInterest)(FnViewportCameraHostHandle handle,
            double coi);

        double (*getFOV)(FnViewportCameraHostHandle handle);
        void (*setFOV)(FnViewportCameraHostHandle handle, double fov);

        double (*getOrthographicWidth)(FnViewportCameraHostHandle handle);
        void (*setOrthographicWidth)(FnViewportCameraHostHandle handle,
            double width);

        void (*getNearFar)(FnViewportCameraHostHandle handle, double *near,
            double *far);
        void (*setNearFar)(FnViewportCameraHostHandle handle, double near,
            double far);

        void (*getScreenWindow)(FnViewportCameraHostHandle handle,
            double *left, double *right, double *bottom, double *top);
        void (*setScreenWindow)(FnViewportCameraHostHandle handle,
            double left, double right, double bottom, double top);

        void (*getOrigin)(FnViewportCameraHostHandle handle, double* x,
            double* y, double* z);
        void (*getDirection)(FnViewportCameraHostHandle handle, double* x,
            double* y, double* z);
        void (*getUp)(FnViewportCameraHostHandle handle, double* x, double* y,
            double* z);
        void (*getLeft)(FnViewportCameraHostHandle handle, double* x, double* y,
            double* z);

        void (*getViewport)(
            FnViewportCameraHostHandle handle,
            FnViewportHostHandle* viewportHostHandle,
            FnViewportPluginHandle* viewportPluginHandle,
            FnViewportPluginSuite_v2** viewportPluginSuite);
    };


    struct FnViewportCameraHostSuite_v2
    {

        const double* (*getViewMatrix)(FnViewportCameraHostHandle handle);
        void (*setViewMatrix)(FnViewportCameraHostHandle handle,
            const double* matrix);

        const double* (*getProjectionMatrix)(FnViewportCameraHostHandle handle);
        void (*setProjectionMatrix)(FnViewportCameraHostHandle handle,
            const double* matrix);

        double (*getCenterOfInterest)(FnViewportCameraHostHandle handle);
        void (*setCenterOfInterest)(FnViewportCameraHostHandle handle,
            double coi);

        double (*getFOV)(FnViewportCameraHostHandle handle);
        void (*setFOV)(FnViewportCameraHostHandle handle, double fov);

        double (*getOrthographicWidth)(FnViewportCameraHostHandle handle);
        void (*setOrthographicWidth)(FnViewportCameraHostHandle handle,
            double width);

        void (*getNearFar)(FnViewportCameraHostHandle handle, double *near,
            double *far);
        void (*setNearFar)(FnViewportCameraHostHandle handle, double near,
            double far);

        void (*getScreenWindow)(FnViewportCameraHostHandle handle,
            double *left, double *right, double *bottom, double *top);
        void (*setScreenWindow)(FnViewportCameraHostHandle handle,
            double left, double right, double bottom, double top);

        void (*getOrigin)(FnViewportCameraHostHandle handle, double* x,
            double* y, double* z);
        void (*getDirection)(FnViewportCameraHostHandle handle, double* x,
            double* y, double* z);
        void (*getUp)(FnViewportCameraHostHandle handle, double* x, double* y,
            double* z);
        void (*getLeft)(FnViewportCameraHostHandle handle, double* x, double* y,
            double* z);

        void (*getViewport)(
            FnViewportCameraHostHandle handle,
            FnViewportHostHandle* viewportHostHandle,
            FnViewportPluginHandle* viewportPluginHandle,
            FnViewportPluginSuite_v2** viewportPluginSuite);

        int (*hasLocationPath)(FnViewportCameraHostHandle handle);

        const char* (*getLocationPath)(FnViewportCameraHostHandle handle);

        void (*setLocationPath)(FnViewportCameraHostHandle handle,
            const char* locationPath);

        bool (*isInteractionDisabled)(FnViewportCameraHostHandle handle);
        void (*disableInteraction)(FnViewportCameraHostHandle handle,
            bool disabled);
    };

}

#endif //FNVIEWER_FNVIEWPORTCAMERASUITE_H
