// Copyright (c) 2016 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FNVIEWER_FNVIEWERDELEGATESUITE_H
#define FNVIEWER_FNVIEWERDELEGATESUITE_H

#include <FnAttribute/suite/FnAttributeSuite.h>
#include <FnGeolib/suite/FnGeolibRuntimeSuite.h>

#include "FnViewportSuite.h"
#include "FnViewerDelegateComponentSuite.h"

struct FnViewportPluginStruct;
typedef struct FnViewportPluginStruct* FnViewportPluginHandle;
struct FnViewportHostStruct;
typedef FnViewportHostStruct* FnViewportHostHandle;

extern "C"
{
    typedef struct FnViewerDelegatePluginStruct* FnViewerDelegatePluginHandle;
    typedef struct FnViewerDelegateHostStruct* FnViewerDelegateHostHandle;

    struct FnViewportPluginSuite_v2;                     // Forward declaration
    struct FnViewerDelegateComponentPluginSuite_v2;      // Forward declaration

    enum {
        kFnViewerLocationEvent_localXformIsAbsolute                 = 1u << 0,
        kFnViewerLocationEvent_excluded                             = 1u << 1,
        kFnViewerLocationEvent_descendantsHidden                    = 1u << 2,
        kFnViewerLocationEvent_isVirtualLocation                    = 1u << 3,

        kFnViewerLocationEvent_locationRemoved                      = 1u << 16,
        kFnViewerLocationEvent_attributesUpdated                    = 1u << 17,
        kFnViewerLocationEvent_localXformUpdated                    = 1u << 18,
        kFnViewerLocationEvent_excludedChanged                      = 1u << 19,
        kFnViewerLocationEvent_descendantsHiddenChanged             = 1u << 20,
    };
    typedef uint32_t FnViewerLocationEventBitField;

    struct FnViewerLocationEventStruct
    {
        const char* locationPath;
        FnAttributeHandle attributes;
        FnAttributeHandle localXformMatrix;
        FnViewerLocationEventBitField flags;
    };

    enum FnViewerDelegateSceneView
    {
        kFnViewerDelegatePrimary,
        kFnViewerDelegateSources,
        kFnViewerDelegateLookThrough,

        kFnViewerDelegateMax,
    };

    #define FnViewerDelegatePluginSuite_version 3
    #define FnViewerDelegateHostSuite_version 4

    struct FnViewerDelegatePluginSuite_v3
    {
        FnViewerDelegatePluginHandle (*create)(
            FnViewerDelegateHostHandle hostHandle);

        void (*destroy)(FnViewerDelegatePluginHandle handle);

        void (*locationEvent)(FnViewerDelegatePluginHandle handle,
            FnViewerLocationEventStruct* event, uint8_t locationHandled);

        void (*sourceLocationEvent)(FnViewerDelegatePluginHandle handle,
            FnViewerLocationEventStruct* event);

        void (*locationsSelected)(FnViewerDelegatePluginHandle handle,
            const char** locationPaths, int64_t numPaths);

        void (*setOption)( FnViewerDelegatePluginHandle handle,
            uint64_t optionId, FnAttributeHandle attr);

        FnAttributeHandle (*getOption)( FnViewerDelegatePluginHandle handle,
            uint64_t optionId);

        void (*freeze)(FnViewerDelegatePluginHandle handle);

        void (*thaw)(FnViewerDelegatePluginHandle handle);

        void (*setup)(FnViewerDelegatePluginHandle handle);

        void (*cleanup)(FnViewerDelegatePluginHandle handle);

        int (*isProcessing)(FnViewerDelegatePluginHandle handle);

        FnAttributeHandle (*getBounds)(FnViewerDelegatePluginHandle handle,
            const char* location);
        FnAttributeHandle (*computeExtent)(FnViewerDelegatePluginHandle handle,
            const char* location);
    };

    struct FnViewerDelegateHostSuite_v2
    {
        void (*setViewOp)(FnViewerDelegateHostHandle handle, FnGeolibOpId opId);

        FnAttributeHandle (*getAttributes)(FnViewerDelegateHostHandle handle,
                                           const char* locationPath,
                                           FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getLocalXform)(FnViewerDelegateHostHandle handle,
                                           const char* locationPath,
                                           uint8_t* isAbsolute,
                                           FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getWorldXform)(FnViewerDelegateHostHandle handle,
                                           const char* locationPath,
                                           FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getParentXform)(
            FnViewerDelegateHostHandle handle,
            const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getPartialXform)(
            FnViewerDelegateHostHandle handle,
            const char* locationPath,
            const char* groupName,
            const char* componentName,
            int includeComponent,
            FnViewerDelegateSceneView sceneView);

        void (*openLocations)(FnViewerDelegateHostHandle handle,
                              const char** locationPath,
                              int64_t numPaths);

        void (*closeLocations)(FnViewerDelegateHostHandle handle,
                               const char** locationPath,
                               int64_t numPaths);

        void (*pinLocations)(FnViewerDelegateHostHandle handle,
                             const char** locationPath,
                             int64_t numPaths);

        void (*unpinLocations)(FnViewerDelegateHostHandle handle,
                               const char** locationPath,
                               int64_t numPaths);

        void (*activateSourceLocations)(FnViewerDelegateHostHandle handle,
                                        const char** locationPath,
                                        int64_t numPaths);

        void (*deactivateSourceLocations)(FnViewerDelegateHostHandle handle,
                                          const char** locationPath,
                                          int64_t numPaths);

        void (*setWorkingSetVisibilityEnabled)(
            FnViewerDelegateHostHandle handle,
            uint8_t workingSetVisibilityEnabled);

        uint8_t (*getWorkingSetVisibilityEnabled)(
            FnViewerDelegateHostHandle handle);

        void (*setVisibilityWorkingSet)(FnViewerDelegateHostHandle handle,
                                        FnAttributeHandle workingSetAttr);

        void (*selectLocation)(FnViewerDelegateHostHandle handle,
                               const char* locationPath);

        void (*selectLocations)(FnViewerDelegateHostHandle handle,
                                const char** locationPath,
                                int64_t numPaths);

        FnAttributeHandle (*getSelectedLocations)(
            FnViewerDelegateHostHandle handle);

        FnAttributeHandle (*getCompatibleManipulatorsInfo)(
            FnViewerDelegateHostHandle handle,
            const char** locationPaths,
            int64_t numPaths);

        FnAttributeHandle (*callPythonCallback)(
            FnViewerDelegateHostHandle handle,
            const char* name,
            FnAttributeHandle message);

        void (*addComponent)(
            FnViewerDelegateHostHandle handle,
            const char* pluginName,
            const char* name,
            FnViewerDelegateComponentHostHandle* componentHostHandle,
            FnViewerDelegateComponentPluginHandle* componentPluginHandle,
            FnViewerDelegateComponentPluginSuite_v2** componentPluginSuite);

        void (*getComponentByName)(
            FnViewerDelegateHostHandle handle,
            const char* name,
            FnViewerDelegateComponentHostHandle* componentHostHandle,
            FnViewerDelegateComponentPluginHandle* componentPluginHandle,
            FnViewerDelegateComponentPluginSuite_v2** componentPluginSuite);

        void (*getComponentByIndex)(
            FnViewerDelegateHostHandle handle,
            unsigned int index,
            FnViewerDelegateComponentHostHandle* componentHostHandle,
            FnViewerDelegateComponentPluginHandle* componentPluginHandle,
            FnViewerDelegateComponentPluginSuite_v2** componentPluginSuite);

        void (*removeComponentByName)(FnViewerDelegateHostHandle handle,
                                      const char* name);

        void (*removeComponentByIndex)(FnViewerDelegateHostHandle handle,
                                       unsigned int index);

        unsigned int (*getNumberOfComponents)(
            FnViewerDelegateHostHandle handle);

        const char* (*getComponentName)(FnViewerDelegateHostHandle handle,
                                        unsigned int index);

        void (*addViewport)(FnViewerDelegateHostHandle handle,
                            FnViewportHostHandle viewportHandle,
                            const char* name);

        void (*getViewportByName)(
            FnViewerDelegateHostHandle handle,
            const char* name,
            FnViewportHostHandle* viewportHostHandle,
            FnViewportPluginHandle* viewportPluginHandle,
            FnViewportPluginSuite_v2** viewportPluginSuite);

        void (*getViewportByIndex)(
            FnViewerDelegateHostHandle handle,
            unsigned int index,
            FnViewportHostHandle* viewportHostHandle,
            FnViewportPluginHandle* viewportPluginHandle,
            FnViewportPluginSuite_v2** viewportPluginSuite);

        void (*removeViewportByName)(FnViewerDelegateHostHandle handle,
                                     const char* name);

        void (*removeViewportByIndex)(FnViewerDelegateHostHandle handle,
                                      unsigned int index);

        unsigned int (*getNumberOfViewports)(FnViewerDelegateHostHandle handle);

        const char* (*getViewportName)(FnViewerDelegateHostHandle handle,
                                       unsigned int index);

        int (*setManipulatedAttribute)(FnViewerDelegateHostHandle handle,
                                       const char* locationPath,
                                       const char* attrName,
                                       FnAttributeHandle valueAttrHandle,
                                       int isFinal);

        void (*openManipulationGroup)(FnViewerDelegateHostHandle handle,
                                      const char* locationPath);

        void (*closeManipulationGroup)(FnViewerDelegateHostHandle handle,
                                       const char* locationPath);

        void (*setBoundingBoxesEnabled)(FnViewerDelegateHostHandle handle,
                                        uint8_t enabled);

        void (*setProxyGeometryEnabled)(FnViewerDelegateHostHandle handle,
                                        uint8_t enabled);

        FnAttributeHandle (*getDescendantLocations)(
            FnViewerDelegateHostHandle handle,
            const char* locationPath);

        FnAttributeHandle (*getLiveAttributes)(
            FnViewerDelegateHostHandle handle,
            const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getCookedAttributes)(
            FnViewerDelegateHostHandle handle,
            const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        int (*isProcessing)(FnViewerDelegateHostHandle handle);

        FnAttributeHandle (*computeMergedExtent)(
            FnViewerDelegateHostHandle handle,
            const char** locations,
            int64_t locationCount,
            const char* excludeLocation);

        void (*insertComponent)(
            FnViewerDelegateHostHandle handle,
            const char* pluginName,
            const char* name,
            unsigned int index,
            FnViewerDelegateComponentHostHandle* componentHostHandle,
            FnViewerDelegateComponentPluginHandle* componentPluginHandle,
            FnViewerDelegateComponentPluginSuite_v2** componentPluginSuite);

        int (*getComponentIndex)(FnViewerDelegateHostHandle handle,
                                 const char* name);

        void (*hideLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, uint64_t numPaths);

        void (*unhideLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, uint64_t numPaths);

        void (*unhideAllLocations)(FnViewerDelegateHostHandle handle);

        FnAttributeHandle (*getHiddenLocations)(
            FnViewerDelegateHostHandle handle);
    };

    struct FnViewerDelegateHostSuite_v3
    {
        void (*setViewOp)(FnViewerDelegateHostHandle handle,FnGeolibOpId opId);

        FnAttributeHandle (*getAttributes)(
            FnViewerDelegateHostHandle handle, const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getLocalXform)(
            FnViewerDelegateHostHandle handle, const char* locationPath,
            uint8_t* isAbsolute, FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getWorldXform)(
            FnViewerDelegateHostHandle handle, const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getParentXform)(
            FnViewerDelegateHostHandle handle, const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getPartialXform)(
            FnViewerDelegateHostHandle handle, const char* locationPath,
            const char* groupName, const char* componentName,
            int includeComponent, FnViewerDelegateSceneView sceneView,
            int includeParentXform, int includeBeforeGroup,
            int includeAfterGroup);

        void (*openLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        void (*closeLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        void (*pinLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        void (*unpinLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        void (*activateSourceLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        void (*deactivateSourceLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        void (*setWorkingSetVisibilityEnabled)(
            FnViewerDelegateHostHandle handle,
            uint8_t workingSetVisibilityEnabled);

        uint8_t (*getWorkingSetVisibilityEnabled)(
                FnViewerDelegateHostHandle handle);

        void (*setVisibilityWorkingSet)(FnViewerDelegateHostHandle handle,
                FnAttributeHandle workingSetAttr);

        void (*selectLocation)(FnViewerDelegateHostHandle handle,
            const char* locationPath);

        void (*selectLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        FnAttributeHandle (*getSelectedLocations)(
            FnViewerDelegateHostHandle handle);

        FnAttributeHandle (*getCompatibleManipulatorsInfo)(
            FnViewerDelegateHostHandle handle, const char** locationPaths,
            int64_t numPaths);

        FnAttributeHandle (*callPythonCallback)(
            FnViewerDelegateHostHandle handle, const char* name,
            FnAttributeHandle message);

        void (*addComponent)(
            FnViewerDelegateHostHandle handle, const char* pluginName,
            const char* name,
            FnViewerDelegateComponentHostHandle* componentHostHandle,
            FnViewerDelegateComponentPluginHandle* componentPluginHandle,
            FnViewerDelegateComponentPluginSuite_v2** componentPluginSuite);

        void (*getComponentByName)(
            FnViewerDelegateHostHandle handle, const char* name,
            FnViewerDelegateComponentHostHandle* componentHostHandle,
            FnViewerDelegateComponentPluginHandle* componentPluginHandle,
            FnViewerDelegateComponentPluginSuite_v2** componentPluginSuite);

        void (*getComponentByIndex)(
            FnViewerDelegateHostHandle handle, unsigned int index,
            FnViewerDelegateComponentHostHandle* componentHostHandle,
            FnViewerDelegateComponentPluginHandle* componentPluginHandle,
            FnViewerDelegateComponentPluginSuite_v2** componentPluginSuite);

        void (*removeComponentByName)( FnViewerDelegateHostHandle handle,
            const char* name );

        void (*removeComponentByIndex)( FnViewerDelegateHostHandle handle,
            unsigned int index );

        unsigned int (*getNumberOfComponents)(
            FnViewerDelegateHostHandle handle );

        const char* (*getComponentName)( FnViewerDelegateHostHandle handle,
            unsigned int index );

        void (*addViewport)(FnViewerDelegateHostHandle handle,
            FnViewportHostHandle viewportHandle,
            const char* name);

        void (*getViewportByName)(
            FnViewerDelegateHostHandle handle, const char* name,
            FnViewportHostHandle* viewportHostHandle,
            FnViewportPluginHandle* viewportPluginHandle,
            FnViewportPluginSuite_v2** viewportPluginSuite);

        void (*getViewportByIndex)(
            FnViewerDelegateHostHandle handle, unsigned int index,
            FnViewportHostHandle* viewportHostHandle,
            FnViewportPluginHandle* viewportPluginHandle,
            FnViewportPluginSuite_v2** viewportPluginSuite);

        void (*removeViewportByName)(FnViewerDelegateHostHandle handle,
            const char* name);

        void (*removeViewportByIndex)(FnViewerDelegateHostHandle handle,
            unsigned int index);

        unsigned int (*getNumberOfViewports)(
            FnViewerDelegateHostHandle handle);

        const char* (*getViewportName)(FnViewerDelegateHostHandle handle,
            unsigned int index);

        int (*setManipulatedAttribute)( FnViewerDelegateHostHandle handle,
            const char* locationPath, const char* attrName,
            FnAttributeHandle valueAttrHandle, int isFinal);

        void (*openManipulationGroup)(FnViewerDelegateHostHandle handle,
            const char* locationPath);

        void (*closeManipulationGroup)(FnViewerDelegateHostHandle handle,
            const char* locationPath);

        void (*setBoundingBoxesEnabled)(FnViewerDelegateHostHandle handle,
            uint8_t enabled);

        void (*setProxyGeometryEnabled)(FnViewerDelegateHostHandle handle,
            uint8_t enabled);

        FnAttributeHandle (*getDescendantLocations)(
            FnViewerDelegateHostHandle handle,
            const char* locationPath);

        FnAttributeHandle (*getLiveAttributes)(
            FnViewerDelegateHostHandle handle,
            const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getCookedAttributes)(
            FnViewerDelegateHostHandle handle,
            const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        int (*isProcessing)(FnViewerDelegateHostHandle handle);

        FnAttributeHandle (*computeMergedExtent)(
            FnViewerDelegateHostHandle handle, const char** locations,
            int64_t locationCount, const char* excludeLocation);

        void (*insertComponent)(
            FnViewerDelegateHostHandle handle, const char* pluginName,
            const char* name, unsigned int index,
            FnViewerDelegateComponentHostHandle* componentHostHandle,
            FnViewerDelegateComponentPluginHandle* componentPluginHandle,
            FnViewerDelegateComponentPluginSuite_v2** componentPluginSuite);

        int (*getComponentIndex)(FnViewerDelegateHostHandle handle,
            const char* name);

        void (*hideLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, uint64_t numPaths);

        void (*unhideLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, uint64_t numPaths);

        void (*unhideAllLocations)(FnViewerDelegateHostHandle handle);

        FnAttributeHandle (*getHiddenLocations)(
                FnViewerDelegateHostHandle handle);
    };

    struct FnViewerDelegateHostSuite_v4
    {
        void (*setViewOp)(
            FnViewerDelegateHostHandle handle, FnGeolibOpId opId,
            FnGeolibTransactionHandle txnHandle);

        FnAttributeHandle (*getAttributes)(
            FnViewerDelegateHostHandle handle, const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getLocalXform)(
            FnViewerDelegateHostHandle handle, const char* locationPath,
            uint8_t* isAbsolute, FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getWorldXform)(
            FnViewerDelegateHostHandle handle, const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getParentXform)(
            FnViewerDelegateHostHandle handle, const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getPartialXform)(
            FnViewerDelegateHostHandle handle, const char* locationPath,
            const char* groupName, const char* componentName,
            int includeComponent, FnViewerDelegateSceneView sceneView,
            int includeParentXform, int includeBeforeGroup,
            int includeAfterGroup);

        void (*openLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        void (*closeLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        void (*pinLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        void (*unpinLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        void (*activateSourceLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        void (*deactivateSourceLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        void (*setWorkingSetVisibilityEnabled)(
            FnViewerDelegateHostHandle handle,
            uint8_t workingSetVisibilityEnabled);

        uint8_t (*getWorkingSetVisibilityEnabled)(
                FnViewerDelegateHostHandle handle);

        void (*setVisibilityWorkingSet)(FnViewerDelegateHostHandle handle,
                FnAttributeHandle workingSetAttr);

        void (*selectLocation)(FnViewerDelegateHostHandle handle,
            const char* locationPath);

        void (*selectLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, int64_t numPaths);

        FnAttributeHandle (*getSelectedLocations)(
            FnViewerDelegateHostHandle handle);

        FnAttributeHandle (*getCompatibleManipulatorsInfo)(
            FnViewerDelegateHostHandle handle, const char** locationPaths,
            int64_t numPaths);

        FnAttributeHandle (*callPythonCallback)(
            FnViewerDelegateHostHandle handle, const char* name,
            FnAttributeHandle message);

        void (*addComponent)(
            FnViewerDelegateHostHandle handle, const char* pluginName,
            const char* name,
            FnViewerDelegateComponentHostHandle* componentHostHandle,
            FnViewerDelegateComponentPluginHandle* componentPluginHandle,
            FnViewerDelegateComponentPluginSuite_v2** componentPluginSuite);

        void (*getComponentByName)(
            FnViewerDelegateHostHandle handle, const char* name,
            FnViewerDelegateComponentHostHandle* componentHostHandle,
            FnViewerDelegateComponentPluginHandle* componentPluginHandle,
            FnViewerDelegateComponentPluginSuite_v2** componentPluginSuite);

        void (*getComponentByIndex)(
            FnViewerDelegateHostHandle handle, unsigned int index,
            FnViewerDelegateComponentHostHandle* componentHostHandle,
            FnViewerDelegateComponentPluginHandle* componentPluginHandle,
            FnViewerDelegateComponentPluginSuite_v2** componentPluginSuite);

        void (*removeComponentByName)( FnViewerDelegateHostHandle handle,
            const char* name);

        void (*removeComponentByIndex)( FnViewerDelegateHostHandle handle,
            unsigned int index);

        unsigned int (*getNumberOfComponents)(
            FnViewerDelegateHostHandle handle);

        const char* (*getComponentName)( FnViewerDelegateHostHandle handle,
            unsigned int index);

        void (*addViewport)(FnViewerDelegateHostHandle handle,
            FnViewportHostHandle viewportHandle,
            const char* name);

        void (*getViewportByName)(
            FnViewerDelegateHostHandle handle, const char* name,
            FnViewportHostHandle* viewportHostHandle,
            FnViewportPluginHandle* viewportPluginHandle,
            FnViewportPluginSuite_v2** viewportPluginSuite);

        void (*getViewportByIndex)(
            FnViewerDelegateHostHandle handle, unsigned int index,
            FnViewportHostHandle* viewportHostHandle,
            FnViewportPluginHandle* viewportPluginHandle,
            FnViewportPluginSuite_v2** viewportPluginSuite);

        void (*removeViewportByName)(FnViewerDelegateHostHandle handle,
            const char* name);

        void (*removeViewportByIndex)(FnViewerDelegateHostHandle handle,
            unsigned int index);

        unsigned int (*getNumberOfViewports)(
            FnViewerDelegateHostHandle handle);

        const char* (*getViewportName)(FnViewerDelegateHostHandle handle,
            unsigned int index);

        int (*setManipulatedAttribute)( FnViewerDelegateHostHandle handle,
            const char* locationPath, const char* attrName,
            FnAttributeHandle valueAttrHandle, int isFinal);

        void (*openManipulationGroup)(FnViewerDelegateHostHandle handle,
            const char* locationPath);

        void (*closeManipulationGroup)(FnViewerDelegateHostHandle handle,
            const char* locationPath);

        void (*setBoundingBoxesEnabled)(FnViewerDelegateHostHandle handle,
            uint8_t enabled);

        void (*setProxyGeometryEnabled)(FnViewerDelegateHostHandle handle,
            uint8_t enabled);

        FnAttributeHandle (*getDescendantLocations)(
            FnViewerDelegateHostHandle handle,
            const char* locationPath);

        FnAttributeHandle (*getLiveAttributes)(
            FnViewerDelegateHostHandle handle,
            const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        FnAttributeHandle (*getCookedAttributes)(
            FnViewerDelegateHostHandle handle,
            const char* locationPath,
            FnViewerDelegateSceneView sceneView);

        int (*isProcessing)(FnViewerDelegateHostHandle handle);

        FnAttributeHandle (*computeMergedExtent)(
            FnViewerDelegateHostHandle handle, const char** locations,
            int64_t locationCount, const char* excludeLocation);

        void (*insertComponent)(
            FnViewerDelegateHostHandle handle, const char* pluginName,
            const char* name, unsigned int index,
            FnViewerDelegateComponentHostHandle* componentHostHandle,
            FnViewerDelegateComponentPluginHandle* componentPluginHandle,
            FnViewerDelegateComponentPluginSuite_v2** componentPluginSuite);

        int (*getComponentIndex)(FnViewerDelegateHostHandle handle,
            const char* name);

        void (*hideLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, uint64_t numPaths);

        void (*unhideLocations)(FnViewerDelegateHostHandle handle,
            const char** locationPath, uint64_t numPaths);

        void (*unhideAllLocations)(FnViewerDelegateHostHandle handle);

        FnAttributeHandle (*getHiddenLocations)(
                FnViewerDelegateHostHandle handle);
    };
}

#endif
