// Copyright (c) 2016 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FNVIEWER_FNVIEWPORTLAYERCOMPONENTSUITE_H
#define FNVIEWER_FNVIEWPORTLAYERCOMPONENTSUITE_H

extern "C"
{
    typedef struct FnViewerDelegateComponentPluginStruct* FnViewerDelegateComponentPluginHandle;
    typedef struct FnViewerDelegateComponentHostStruct* FnViewerDelegateComponentHostHandle;

    struct FnViewerDelegatePluginSuite_v3;  // Forward declaration
    typedef struct FnViewerLocationEventStruct FnViewerLocationEventStruct;

    #include <FnAttribute/suite/FnAttributeSuite.h>
    #include <FnGeolib/suite/FnGeolibRuntimeSuite.h>

    #include "FnViewerDelegateSuite.h"

    #define FnViewerDelegateComponentPluginSuite_version 2
    #define FnViewerDelegateComponentHostSuite_version 2

    struct FnViewerDelegateComponentPluginSuite_v2
    {
        FnViewerDelegateComponentPluginHandle (*create)(
            FnViewerDelegateComponentHostHandle hostHandle);

        void (*destroy)(FnViewerDelegateComponentPluginHandle handle);

        int (*locationEvent)(FnViewerDelegateComponentPluginHandle handle,
            FnViewerLocationEventStruct* event, uint8_t locationHandled);

        void (*locationsSelected)(
            FnViewerDelegateComponentPluginHandle handle,
            const char** locationPaths, int64_t numPaths);

        void (*setOption)( FnViewerDelegateComponentPluginHandle handle,
            uint64_t optionId, FnAttributeHandle attr);

        FnAttributeHandle (*getOption)( FnViewerDelegateComponentPluginHandle handle,
            uint64_t optionId);

        void(*setup)(FnViewerDelegateComponentPluginHandle handle);

        void(*cleanup)(FnViewerDelegateComponentPluginHandle handle);

        int (*isProcessing)(FnViewerDelegateComponentPluginHandle handle);

        FnAttributeHandle (*getBounds)(
            FnViewerDelegateComponentPluginHandle handle, const char* location);
        FnAttributeHandle (*computeExtent)(
            FnViewerDelegateComponentPluginHandle handle, const char* location);
    };

    struct FnViewerDelegateComponentHostSuite_v2
    {
        void (*getViewerDelegate)(FnViewerDelegateComponentHostHandle handle,
            FnViewerDelegateHostHandle* delegateHostHandle,
            FnViewerDelegatePluginHandle* delegatePluginHandle,
            FnViewerDelegatePluginSuite_v3** delegatePluginSuite);

        int (*isProcessing)(FnViewerDelegateComponentHostHandle handle);
    };

}

#endif //FNVIEWER_FNVIEWPORTLAYERCOMPONENTSUITE_H
