// Copyright (c) 2016 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FNVIEWER_FNMANIOULATORSUITE_H
#define FNVIEWER_FNMANIOULATORSUITE_H

#include <stdint.h>

extern "C"
{
    typedef struct FnManipulatorPluginStruct* FnManipulatorPluginHandle;
    typedef struct FnManipulatorHostStruct* FnManipulatorHostHandle;

    struct FnViewportPluginSuite_v2;          // Forward declaration
    struct FnManipulatorHandlePluginSuite_v1; // Forward declaration

    #include <FnAttribute/suite/FnAttributeSuite.h>

    #include "FnViewportSuite.h"
    #include "FnManipulatorHandleSuite.h"

    #define FnManipulatorPluginSuite_version 1
    #define FnManipulatorHostSuite_version 2

    struct FnManipulatorPluginSuite_v1
    {
        FnManipulatorPluginHandle (*create)(
            FnManipulatorHostHandle hostHandle);

        void (*destroy)(FnManipulatorPluginHandle handle);

        int (*matches)(FnAttributeHandle locationAttributesHandle);

        FnAttributeHandle (*getTags)();

        void (*setup)(FnManipulatorPluginHandle handle);

        int (*event)(FnManipulatorPluginHandle handle,
            FnAttributeHandle eventAttrHandle);

        void (*draw)(FnManipulatorPluginHandle handle);

        void (*pickerDraw)(FnManipulatorPluginHandle handle, int64_t pickerId);

        void (*setOption)(FnManipulatorPluginHandle handle,
                          uint64_t optionId, FnAttributeHandle attr);

        FnAttributeHandle (*getOption)(FnManipulatorPluginHandle handle,
                                       uint64_t optionId);

    };

    struct FnManipulatorHostSuite_v1  // Old suite
    {
        const char* (*getPluginName)(FnManipulatorHostHandle handle);

        int (*event)(FnManipulatorHostHandle handle,
                     FnAttributeHandle eventAttrHandle);

        void (*draw)(FnManipulatorHostHandle handle);

        void (*pickerDraw)(FnManipulatorHostHandle handle, int64_t pickerId);

        FnAttributeHandle (*getXform)(FnManipulatorHostHandle handle);

        void (*setXform)(FnManipulatorHostHandle handle,
            FnAttributeHandle xformMatrix);

        FnAttributeHandle (*calculateAveragePositionXform)(
            FnManipulatorHostHandle handle);

        FnAttributeHandle (*getValue)(FnManipulatorHostHandle handle,
                                      const char* locationPath,
                                      const char* attrName);

        int (*setValue)(FnManipulatorHostHandle handle,
                        const char* locationPath, const char* attrName,
                        FnAttributeHandle valueAttrHandle, int isFinal);

        void (*getViewport)(
            FnManipulatorHostHandle handle,
            FnViewportHostHandle* viewportHostHandle,
            FnViewportPluginHandle* viewportPluginHandle,
            FnViewportPluginSuite_v2** viewportPluginSuite);

        FnAttributeHandle (*getLocationPaths)(FnManipulatorHostHandle handle);

        void (*addManipulatorHandle)(
            FnManipulatorHostHandle handle,
            const char* pluginName, const char* name,
            FnManipulatorHandleHostHandle* manipulatorHandleHostHandle,
            FnManipulatorHandlePluginHandle* manipulatorHandlePluginHandle,
            FnManipulatorHandlePluginSuite_v1** manipulatorHandlePluginSuite);

        void (*getManipulatorHandleByName)(
            FnManipulatorHostHandle handle, const char* name,
            FnManipulatorHandleHostHandle* manipulatorHandleHostHandle,
            FnManipulatorHandlePluginHandle* manipulatorHandlePluginHandle,
            FnManipulatorHandlePluginSuite_v1** manipulatorHandlePluginSuite);

        void (*getManipulatorHandleByIndex)(
            FnManipulatorHostHandle handle, unsigned int index,
            FnManipulatorHandleHostHandle* manipulatorHandleHostHandle,
            FnManipulatorHandlePluginHandle* manipulatorHandlePluginHandle,
            FnManipulatorHandlePluginSuite_v1** manipulatorHandlePluginSuite);

        void (*removeManipulatorHandleByName)(FnManipulatorHostHandle handle,
                                              const char* name);

        void (*removeManipulatorHandleByIndex)(FnManipulatorHostHandle handle,
                                               unsigned int index);

        unsigned int (*getNumberOfManipulatorHandles)(
            FnManipulatorHostHandle handle);

        const char* (*getManipulatorHandleName)(FnManipulatorHostHandle handle,
                                                unsigned int index);
    };

    struct FnManipulatorHostSuite_v2
    {
        const char* (*getPluginName)(FnManipulatorHostHandle handle);

        int (*event)(FnManipulatorHostHandle handle,
                     FnAttributeHandle eventAttrHandle);

        void (*draw)(FnManipulatorHostHandle handle);

        void (*pickerDraw)(FnManipulatorHostHandle handle, int64_t pickerId);

        FnAttributeHandle (*getXform)(FnManipulatorHostHandle handle);

        void (*setXform)(FnManipulatorHostHandle handle,
            FnAttributeHandle xformMatrix);

        FnAttributeHandle (*calculateAveragePositionXform)(
            FnManipulatorHostHandle handle);

        FnAttributeHandle (*getValue)(FnManipulatorHostHandle handle,
                                      const char* locationPath,
                                      const char* attrName);

        int (*setValue)(FnManipulatorHostHandle handle,
                        const char* locationPath, const char* attrName,
                        FnAttributeHandle valueAttrHandle, int isFinal);

        void (*getViewport)(
            FnManipulatorHostHandle handle,
            FnViewportHostHandle* viewportHostHandle,
            FnViewportPluginHandle* viewportPluginHandle,
            FnViewportPluginSuite_v2** viewportPluginSuite);

        FnAttributeHandle (*getLocationPaths)(FnManipulatorHostHandle handle);

        void (*addManipulatorHandle)(
            FnManipulatorHostHandle handle,
            const char* pluginName, const char* name,
            FnManipulatorHandleHostHandle* manipulatorHandleHostHandle,
            FnManipulatorHandlePluginHandle* manipulatorHandlePluginHandle,
            FnManipulatorHandlePluginSuite_v1** manipulatorHandlePluginSuite);

        void (*getManipulatorHandleByName)(
            FnManipulatorHostHandle handle, const char* name,
            FnManipulatorHandleHostHandle* manipulatorHandleHostHandle,
            FnManipulatorHandlePluginHandle* manipulatorHandlePluginHandle,
            FnManipulatorHandlePluginSuite_v1** manipulatorHandlePluginSuite);

        void (*getManipulatorHandleByIndex)(
            FnManipulatorHostHandle handle, unsigned int index,
            FnManipulatorHandleHostHandle* manipulatorHandleHostHandle,
            FnManipulatorHandlePluginHandle* manipulatorHandlePluginHandle,
            FnManipulatorHandlePluginSuite_v1** manipulatorHandlePluginSuite);

        void (*removeManipulatorHandleByName)(FnManipulatorHostHandle handle,
                                              const char* name);

        void (*removeManipulatorHandleByIndex)(FnManipulatorHostHandle handle,
                                               unsigned int index);

        unsigned int (*getNumberOfManipulatorHandles)(
            FnManipulatorHostHandle handle);

        const char* (*getManipulatorHandleName)(FnManipulatorHostHandle handle,
                                                unsigned int index);

        FnAttributeHandle (*GetRegisteredManipulatorsInfo)();

        int (*isInteractive)(FnManipulatorHostHandle handle);

        void (*openManipulationGroup)(FnManipulatorHostHandle handle,
                                      const char* locationPath);

        void (*closeManipulationGroup)(FnManipulatorHostHandle handle,
                                       const char* locationPath);
    };
}

#endif //FNVIEWER_FNMANIOULATORSUITE_H
