// Copyright (c) 2016 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FNVIEWER_FNMANIPULATORHANDLESUITE_H
#define FNVIEWER_FNMANIPULATORHANDLESUITE_H

#include <stdint.h>

extern "C"
{
    typedef struct FnManipulatorHandlePluginStruct* FnManipulatorHandlePluginHandle;
    typedef struct FnManipulatorHandleHostStruct* FnManipulatorHandleHostHandle;

    struct FnManipulatorPluginSuite_v1; // Forward declaration

    #include <FnAttribute/suite/FnAttributeSuite.h>

    #include "FnManipulatorSuite.h"


    #define FnManipulatorHandlePluginSuite_version 1
    #define FnManipulatorHandleHostSuite_version 1

    struct FnManipulatorHandlePluginSuite_v1
    {
        FnManipulatorHandlePluginHandle (*create)(
            FnManipulatorHandleHostHandle hostHandle);

        void (*destroy)(FnManipulatorHandlePluginHandle handle);

        int (*event)(FnManipulatorHandlePluginHandle handle,
            FnAttributeHandle eventAttrHandle);

        void (*draw)(FnManipulatorHandlePluginHandle handle);

        void (*pickerDraw)(FnManipulatorHandlePluginHandle handle,
            int64_t pickerId);

        void (*setOption)( FnManipulatorHandlePluginHandle handle,
            uint64_t optionId, FnAttributeHandle attr);

        FnAttributeHandle (*getOption)( FnManipulatorHandlePluginHandle handle,
            uint64_t optionId);

        void (*cancelManipulation)(FnManipulatorHandlePluginHandle handle);
    };

    struct FnManipulatorHandleHostSuite_v1
    {
        void (*getManipulator)(
            FnManipulatorHandleHostHandle handle,
            FnManipulatorHostHandle* manipulatorHostHandle,
            FnManipulatorPluginHandle* manipulatorPluginHandle,
            FnManipulatorPluginSuite_v1** manipulatorPluginSuite);

        FnAttributeHandle (*getXform)(FnManipulatorHandleHostHandle handle);

        void (*setLocalXform)(FnManipulatorHandleHostHandle handle,
            FnAttributeHandle xformAttr);

        FnAttributeHandle (*getLocalXform)(
            FnManipulatorHandleHostHandle handle);

        int (*event)(FnManipulatorHandleHostHandle handle,
            FnAttributeHandle eventAttrHandle);

        void (*draw)(FnManipulatorHandleHostHandle handle);

        void (*pickerDraw)(FnManipulatorHandleHostHandle handle,
            int64_t pickerId);

        void (*setActive)(FnManipulatorHandleHostHandle handle,
            uint8_t active);

        uint8_t (*isActive)(FnManipulatorHandleHostHandle handle);

        void (*setHovered)(FnManipulatorHandleHostHandle handle,
            uint8_t hovered);

        uint8_t (*isHovered)(FnManipulatorHandleHostHandle handle);

        void (*cancelManipulation)(FnManipulatorHandleHostHandle handle);
    };

}

#endif //FNVIEWER_FNMANIPULATORHANDLESUITE_H
