#ifndef FnOptionHash_H
#define FnOptionHash_H

#include <FnAttribute/FnAttribute.h>
#include <FnPluginSystem/FnPluginSystem.h>
#include <FnPluginSystem/FnPlugin.h>
#include <FnViewer/suite/FnOptionIdGeneratorSuite.h>

namespace Foundry
{
namespace Katana
{
namespace ViewerAPI
{

/**
 * \defgroup FnOptionIdGenerator Option ID Generator
 * @{
 */

class OptionIdGenerator
{
public:
    typedef uint64_t value_type;

    /**
    * @brief Generates an option ID from a string.
    *
    * The bottom 16 bits of the ID are not used and reserved for user specified
    * cases.
    */
    static value_type GenerateId(const char* text);

    /**
    * @brief Returns the string used to generate an option ID.
    *
    * Note that this function can only return a result if the option ID was
    * create prior to this call via GenerateId().
    */
    static const char* LookUpOptionId(value_type hash);

    static FnOptionIdGeneratorHostHandle getHandle() {
        if (_handle == 0x0)
            _handle = getSuite()->create();
        return _handle;
    }

    static const FnOptionIdGeneratorHostSuite_v1 *getSuite();

    static void setSuite(const FnOptionIdGeneratorHostSuite_v1 *suite);

    static FnPlugStatus setHost(FnPluginHost *host);

private:
    // no copy/assign
    OptionIdGenerator(){}
    OptionIdGenerator(const OptionIdGenerator& rhs);
    OptionIdGenerator& operator=(const OptionIdGenerator& rhs);

    static FnOptionIdGeneratorHostHandle _handle;
    const static FnOptionIdGeneratorHostSuite_v1* _optionIdGeneratorSuite;
    static FnPluginHost* _host;
};

/** @} */

} // ViewerAPI
} // Katana
} // Foundry
#endif // FnOptionHash_H
