// Copyright (c) 2016 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FNEVENTWRAPPER_H_
#define FNEVENTWRAPPER_H_

#include <FnAttribute/FnAttribute.h>
#include <string>

namespace Foundry
{
namespace Katana
{
namespace ViewerAPI
{

/**
 * \defgroup FnEventWrapper Event Wrapper
 * @{
 */

/**
 * @brief A Wrapper for UI events
 *
 * The event is used to pass UI event data from the viewport widget in Katana
 * to Viewports. Events are generated by "EventTranslator" python plug-ins
 * which convert Qt QEvents into attributes.
 */
class FnEventWrapper
{
public:
    /**
     * @brief Mouse button enumeration used in the "button" event data
     * attribute.
     */
    enum MouseButtons
    {
        kNoButton = 0,
        kLeftButton = 1,
        kRightButton = 2,
        kMidButton = 4,
        kMiddleButton = kMidButton,
        kXButton1 = 8,
        kXButton2 = 16,
    };

    /**
     * @brief Keyboard modifier enumeration used in the "modifiers" event data
     * attribute.
     */
    enum KeyboardModifiers
    {
        kNoModifier = 0x00000000,
        kShiftModifier = 0x02000000,
        kControlModifier = 0x04000000,
        kAltModifier = 0x08000000,
        kMetaModifier = 0x10000000,
        kKeypadModifier = 0x20000000,
        kGroupSwitchModifier = 0x40000000,
    };

    FnEventWrapper();
    FnEventWrapper(const FnAttribute::GroupAttribute& attr);
    FnEventWrapper(const FnEventWrapper& other);
    ~FnEventWrapper();

    /// Returns the type of event as a string.
    std::string getType() const;
    /// Returns the hash of the eventType StringAttribute for faster
    /// comparisons.
    FnAttribute::Hash getTypeHash() const;
    /// Returns a GroupAttribute containing the additional event data.
    FnAttribute::GroupAttribute getData() const;
    /// Returns an attribute handle for the event data.
    FnAttributeHandle getHandle() const;
    /// Returns a retained attribute handle for the event data.
    FnAttributeHandle getRetainedHandle() const;
private:
    /// The wrapped attribute.
    FnAttribute::GroupAttribute m_data;
};

/** @} */

}  // namespace ViewerAPI
}  // namespace Katana
}  // namespace Foundry


#endif /* FNEVENTWRAPPER_H_ */
