// Copyright (c) 2013 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FNRENDER_FNRENDERPLUGINSUITE_H
#define FNRENDER_FNRENDERPLUGINSUITE_H

extern "C" {
typedef struct FnRenderPluginStruct* FnRenderPluginHandle;

#include "FnAttribute/suite/FnAttributeSuite.h"
#include "FnScenegraphIterator/suite/FnScenegraphIteratorSuite.h"

#define FnRenderPluginSuite_version 2

struct FnRenderPluginSuite_v2
{
    FnRenderPluginHandle (*create)(FnSgIteratorHandle rootIteratorHandle,
                                   FnAttributeHandle argsAttributeHandle);

    void (*destroy)(FnRenderPluginHandle renderPluginHandle);

    int (*start)(FnRenderPluginHandle renderPluginHandle);

    int (*pause)(FnRenderPluginHandle renderPluginHandle);

    int (*resume)(FnRenderPluginHandle renderPluginHandle);

    int (*stop)(FnRenderPluginHandle renderPluginHandle);

    int (*startLiveEditing)(FnRenderPluginHandle renderPluginHandle);

    int (*stopLiveEditing)(FnRenderPluginHandle renderPluginHandle);

    int (*processControlCommand)(FnRenderPluginHandle renderPluginHandle,
                                 const char* command);

    int (*queueDataUpdates)(FnRenderPluginHandle renderPluginHandle,
                            FnAttributeHandle commandAttributeHandle);

    bool (*hasPendingDataUpdates)(FnRenderPluginHandle renderPluginHandle);

    int (*applyPendingDataUpdates)(FnRenderPluginHandle renderPluginHandle);

    FnAttributeHandle (*configureDiskRenderOutputProcess)(
        FnRenderPluginHandle renderPluginHandle,
        const char* outputName,
        const char* outputPath,
        const char* renderMethodName,
        const float* frameTime);

    void (*setRootIterator)(FnRenderPluginHandle renderPluginHandle,
                            FnSgIteratorHandle rootIteratorHandle);

    int (*setup)(FnRenderPluginHandle renderPluginHandle);

    int (*cleanup)(FnRenderPluginHandle renderPluginHandle);
};

typedef FnRenderPluginSuite_v2 FnRenderPluginSuite;

struct FnRenderPluginSuite_v1
{
    FnRenderPluginHandle (*create)(FnSgIteratorHandle rootIteratorHandle,
                                   FnAttributeHandle argsAttributeHandle);

    void (*destroy)(FnRenderPluginHandle renderPluginHandle);

    int (*start)(FnRenderPluginHandle renderPluginHandle);

    int (*pause)(FnRenderPluginHandle renderPluginHandle);

    int (*resume)(FnRenderPluginHandle renderPluginHandle);

    int (*stop)(FnRenderPluginHandle renderPluginHandle);

    int (*startLiveEditing)(FnRenderPluginHandle renderPluginHandle);

    int (*stopLiveEditing)(FnRenderPluginHandle renderPluginHandle);

    int (*processControlCommand)(FnRenderPluginHandle renderPluginHandle,
                                 const char* command);

    int (*queueDataUpdates)(FnRenderPluginHandle renderPluginHandle,
                            FnAttributeHandle commandAttributeHandle);

    bool (*hasPendingDataUpdates)(FnRenderPluginHandle renderPluginHandle);

    int (*applyPendingDataUpdates)(FnRenderPluginHandle renderPluginHandle);

    FnAttributeHandle (*configureDiskRenderOutputProcess)(
        FnRenderPluginHandle renderPluginHandle,
        const char* outputName,
        const char* outputPath,
        const char* renderMethodName,
        const float* frameTime);
};
}

#endif
