#ifndef FNRENDER_IDSENDERINTERFACE_H
#define FNRENDER_IDSENDERINTERFACE_H

#include <stdint.h>
#include <string>

#include "FnPlatform/internal/Portability.h"
#include "FnRender/FnRenderAPI.h"

namespace Foundry
{
namespace Katana
{
namespace Render
{
    /**
     * \ingroup RenderAPI
     */

    /**
     * @brief An interface for sending (ID, scene graph location name)
     *        pairs to Katana. This mapping is then used by the color
     *        picker to map a picked ID value in the monitor to the
     *        name of the corresponding scene graph location.
     */
    class FNRENDER_API IdSenderInterface
    {
    public:
        virtual ~IdSenderInterface() {}

        /**
         * Get the next unique ID integer value and the maximum
         * number of IDs.
         *
         * This function is now *deprecated* and shouldn't be called.
         * For backwards compatibility, this function will still return
         * the legacy values nextId = 1 and maxId = 1000000.
         *
         * Now valid IDs range from 1 to 18446744073709551615.
         * Value 0 is reserved.
         *
         * @param nextId A unique incremented ID value
         * @param maxId  The maximum number of ID values
         */
        FNKAT_DEPRECATED
        virtual void getIds(int64_t* nextId, int64_t* maxId) = 0;

        /**
         * Send an ID and scene graph location name pair
         * for a rendered object to Katana.
         *
         * Now valid IDs range from 1 to 18446744073709551615.
         * Value 0 is reserved.
         *
         * @param id         Unique ID
         * @param objectName Scene graph location name
         */
        virtual void send(uint64_t id, const char* const objectName) = 0;
    };
    /**
     * @}
     */
}
}
}

namespace FnKat = Foundry::Katana;

#endif
