#ifndef KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_UNIQUEPTR_H_
#define KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_UNIQUEPTR_H_

#include <FnPlatform/ns.h>

#include <memory>

#if __cplusplus >= 201103L || _MSVC_LANG >= 201103L
#include <type_traits>
#include <utility>
#endif

FNPLATFORM_NAMESPACE_ENTER
{
namespace internal
{
template <typename T>
struct UniquePtr
{
#if __cplusplus >= 201103L || _MSVC_LANG >= 201103L
    typedef typename std::unique_ptr<T> type;
    static inline typename std::remove_reference<type>::type&&
    move(type& obj) noexcept { return std::move(obj); }
#else
    typedef typename std::auto_ptr<T> type;
    static inline type move(type& obj) { return obj; }
#endif
};
}  // namespace internal
}
FNPLATFORM_NAMESPACE_EXIT

#endif  // KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_UNIQUEPTR_H_
