#ifndef KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_TYPETRAITS_H_
#define KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_TYPETRAITS_H_
#include <cstddef>
#include "FnPlatform/internal/Portability.h"

#include <type_traits>

#include "FnPlatform/ns.h"

FNPLATFORM_NAMESPACE_ENTER
{
namespace internal
{
// Implementation of C++11's std::enable_if.
template <bool B, typename T = void> struct EnableIf {};
template <typename T> struct EnableIf<true, T> { typedef T type; };

template <typename From, typename To>
struct IsConvertible : std::is_convertible<From, To> {};

// Member Detector trait for std::string-like types.
// IsStringContainer<T>::value is true if T has both data() and size() methods
// with the expected signatures, false otherwise.
template <typename T>
struct IsStringContainer
{
private:
    typedef char (&Yes)[1];
    typedef char (&No)[2];

    template <typename U, U> struct IsSame;

    template <typename V>
    static Yes Test(IsSame<const char* (V::*)() const, &V::data>*,
                    IsSame<std::size_t (V::*)() const, &V::size>*);
    template <typename> static No Test(...);

public:
    static const bool value = sizeof(Test<T>(0, 0)) == sizeof(Yes);
};

template <typename T, T v>
struct IntegralConstant
{
    typedef T value_type;
    typedef IntegralConstant type;
    static const T value = v;
    operator value_type() const { return v; }
};
}  // namespace internal
}
FNPLATFORM_NAMESPACE_EXIT

#endif  // KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_TYPETRAITS_H_
