#ifndef KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_PORTABILITY_H_
#define KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_PORTABILITY_H_

#ifndef FNKAT_DEPRECATED
#if defined(__GNUC__)
#define FNKAT_DEPRECATED __attribute__((__deprecated__))
#elif defined(_MSC_VER)
#define FNKAT_DEPRECATED __declspec(deprecated)
#else
#define FNKAT_DEPRECATED
#endif
#endif  // FNKAT_DEPRECATED

#if defined(__GNUC__)
#define FNKAT_SUPPRESS_DEPRECATION_WARNINGS \
    _Pragma("GCC diagnostic ignored \"-Wdeprecated-declarations\"")
#elif defined(_MSC_VER)
#define FNKAT_SUPPRESS_DEPRECATION_WARNINGS \
    __pragma(warning(disable : 4996))
#else
#define FNKAT_SUPPRESS_DEPRECATION_WARNINGS
#endif

#if __cplusplus >= 201103L || _MSVC_LANG >= 201103L
#define FNKAT_CXX11 1

#define FNKAT_CONSTEXPR constexpr
#define FNKAT_CONSTEXPR_OR_CONST constexpr
#define FNKAT_NOEXCEPT noexcept

#define FNKAT_LVALUE_REF_QUALIFIER &

#else
#define FNKAT_CONSTEXPR
#define FNKAT_CONSTEXPR_OR_CONST const
#define FNKAT_NOEXCEPT throw()

#define FNKAT_LVALUE_REF_QUALIFIER
#endif

#endif  // KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_PORTABILITY_H_
