#ifndef KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_INDEXSEQUENCE_H_
#define KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_INDEXSEQUENCE_H_
#include <cstddef>
#include "FnPlatform/internal/Portability.h"
#include "FnPlatform/ns.h"

#ifndef FNKAT_CXX11
#error "This header requires C++11"
#endif

FNPLATFORM_NAMESPACE_ENTER
{
namespace internal
{
// Backport of C++14's std::index_sequence.
template <std::size_t... I>
struct IndexSequence
{
    using type = IndexSequence;
    using value_type = std::size_t;
    static constexpr std::size_t size() noexcept { return sizeof...(I); }
};

template <class Sequence1, class Sequence2>
struct MakeIndexSequenceImpl;

template <std::size_t N>
struct MakeIndexSequence
    : MakeIndexSequenceImpl<typename MakeIndexSequence<N / 2>::type,
                            typename MakeIndexSequence<N - N / 2>::type> {};

template <> struct MakeIndexSequence<0> : IndexSequence<> {};
template <> struct MakeIndexSequence<1> : IndexSequence<0> {};

template <std::size_t... I, std::size_t... J>
struct MakeIndexSequenceImpl<IndexSequence<I...>, IndexSequence<J...>>
    : IndexSequence<I..., (sizeof...(I) + J)...> {};

}  // namespace internal
}
FNPLATFORM_NAMESPACE_EXIT

#endif  // KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_INDEXSEQUENCE_H_
