#ifndef KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_ATOMIC_H_
#define KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_ATOMIC_H_

#ifdef _MSC_VER
#include <intrin.h>
#endif  // _MSC_VER

#include <FnPlatform/FnPlatformAPI.h>
#include <FnPlatform/ns.h>

#ifdef _MSC_VER
#pragma intrinsic(_ReadWriteBarrier)
#pragma intrinsic(_InterlockedCompareExchangePointer)
#endif  // _MSC_VER

#if !defined(__x86_64__) && !defined(_M_X64)
#error "This file assumes an Intel 64-bit platform"
#endif

FNPLATFORM_NAMESPACE_ENTER
{
namespace internal
{
// Compiler memory barrier with acquire or release semantics.
static inline void AtomicThreadFenceAcqRel()
{
#ifdef _MSC_VER
    _ReadWriteBarrier();
#else
    __asm__ __volatile__("" ::: "memory");
#endif  // _MSC_VER
}

template <typename T>
static inline bool AtomicCompareExchangeStrong(T* volatile* obj,
                                               T** expected, T* desired)
{
#ifdef _MSC_VER
    T* prev = (T*)_InterlockedCompareExchangePointer(
        (void* volatile*)obj, (void*)desired, (void*)*expected);
#else
    T* prev = __sync_val_compare_and_swap(obj, *expected, desired);
#endif  // _MSC_VER
    if (prev == *expected)
    {
        return true;
    }
    *expected = prev;
    return false;
}
}  // namespace internal
}
FNPLATFORM_NAMESPACE_EXIT

#endif  // KATANA_PLUGINAPI_FNPLATFORM_INTERNAL_ATOMIC_H_
