// Copyright (c) 2012 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FnLoggingSuite_H
#define FnLoggingSuite_H

#include <stdint.h>

extern "C" {

/** @brief Defines for message severity
*/
enum
{
    kFnLoggingSeverityDebug = 10,
    kFnLoggingSeverityInfo = 20,
    kFnLoggingSeverityWarning = 30,
    kFnLoggingSeverityError = 40,
    kFnLoggingSeverityCritical = 50,
};
typedef int FnLoggingSeverity;

typedef void (*FnLogHandler)(const char* message,
                             FnLoggingSeverity severity,
                             const char* module,
                             const char* file,
                             int line,
                             int64_t timestamp,
                             void* userdata);

typedef void (*FnLogHandlerLegacy)(const char* message,
                                   unsigned int severity,
                                   const char* module,
                                   void* userdata);

#define FnLoggingHostSuite_version 1

struct FnLoggingHostSuite_v1
{
    void (*logLegacy)(const char* message,
                      unsigned int severity,
                      const char* module);

    void (*registerHandlerLegacy)(FnLogHandlerLegacy handler,
                                  void* userData,
                                  unsigned int severityFilter,
                                  const char* moduleFilter);
    void (*unregisterHandlerLegacy)(FnLogHandlerLegacy handler, void* userData);

    // log a message
    void (*log)(const char* message,
                FnLoggingSeverity severity,
                const char* module,
                const char* file,
                int line);

    // Returns an opaque token that can be passed to unregisterHandler, or NULL
    // on error.
    void* (*registerHandler)(FnLogHandler handler,
                             void* context,
                             FnLoggingSeverity severityThreshold,
                             const char* module);
    // Returns true iff a handler was unregistered.
    int (*unregisterHandler)(void* handlerToken);

    int (*isSeverityEnabled)(const char* module, FnLoggingSeverity severity);
};
}
#endif  // FnLoggingSuite_H
