// Copyright (c) 2013 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FnGeolibServicesAttributeFunctionUtil_H
#define FnGeolibServicesAttributeFunctionUtil_H

#include <stdint.h>
#include <string>

#include <FnAttribute/FnAttribute.h>

#include <FnGeolibServices/FnGeolibServicesAPI.h>
#include <FnGeolibServices/ns.h>
#include <FnGeolibServices/suite/FnAttributeFunctionUtilSuite.h>

#include <FnPluginSystem/FnPluginSystem.h>

FNGEOLIBSERVICES_NAMESPACE_ENTER
{
    /**
     * \addtogroup FnAttributeFunctionUtil Attribute Functions
     * @{
     */

    /**
     * @brief Provides access to registered AttributeFunction plugins.
     */
    class FNGEOLIBSERVICES_API FnAttributeFunctionUtil
    {
    public:
        /**
         * @brief Runs the AttributeFunction with the specified function name.
         *
         * AttributeFunction plugins are simple plugins which take an
         * FnAttribute instance as input and return an FnAttribute. They are a
         * means of exposing functionality implemented in other plugins across
         * Katana reducing coupling on other modules.
         *
         * AttributeFunctions can be accessed C++, Lua and Python.
         *
         * @param  fncName The name of the AttributeFunction to run.
         * @param  args    An FnAttribute instance encapsulating the arguments
         *                 pass to the AttributeFunction.
         * @return         An FnAttribute instance.
         */
        static FnAttribute::Attribute run(
                const std::string & fncName, FnAttribute::Attribute args);

        /**
         * @brief Gets the list of registered AttributeFunction names that can
         * be invoked via \c run().
         *
         * @param names A vector that will be filled with the
         *              AttributeFunction names.
         * @see FnAttributeFunctionUtil::run()
         */
        static void getRegisteredFunctionNames(std::vector<std::string> & names);

        static void flushCache();

    private:
        FnAttributeFunctionUtil();

        static const FnAttributeFunctionUtilHostSuite_v1 *_getSuite();
    };

    /**
     * @}
     */
}
FNGEOLIBSERVICES_NAMESPACE_EXIT

#endif // FnGeolibServicesAttributeFunctionUtil_H
