// Copyright (c) 2013 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FnConfigSuite_H
#define FnConfigSuite_H

#include <cstdint>

extern "C" {

#define FnConfigHostSuite_version 1

struct FnConfigHostSuite_v1
{
    bool (*has)(const char* key);
    const char* (*get)(const char* key);
    void (*set)(const char* key, const char* value);

    /// Exports a copy of configuration keys and values.
    ///
    /// Format of the export is:
    ///  array[0] = config_key_0
    ///  array[1] = config_value_0
    ///  array[2] = config_key_1
    ///  array[3] = config_value_1
    ///  ...
    ///
    /// Caller is responsible for freeing the allocated memory for each record
    /// using operator delete [], and the containing array using operator
    /// delete[].
    char** (*exportConfiguration)(int64_t* numKeysAndValues);
};
}

#endif // FnConfigSuite_H
