// Copyright (c) 2013 The Foundry Visionmongers Ltd. All Rights Reserved.

#ifndef FnConfig_H
#define FnConfig_H

#include <map>
#include <string>

#include <FnConfig/FnConfigAPI.h>
#include <FnConfig/ns.h>
#include <FnConfig/suite/FnConfigSuite.h>

#include <FnPluginSystem/FnPluginSystem.h>

FNCONFIG_NAMESPACE_ENTER
{
    /**
     * \defgroup FnConfig Config API
     * @{
     */

    /**
     * Provides a number of static methods to access the configuration of the
     * currently running Katana session.
     */
    class FNCONFIG_API Config
    {
    public:

        virtual ~Config();

        /**
         * @param key The key of the configuration entry to be queried.
         * @return True if there is an entry with the given key, otherwise
         *     false.
         */
        static bool has(const std::string& key);

        /**
         * @param key The key of the configuration entry whose value to
         *     retrieve.
         * @return The value of a configuration entry with the given key, or an
         *     empty string if no entry exists with the given key.
         */
        static std::string get(const std::string& key);

        /**
         * @param exportedConfig A map that will be filled with the keys and
         *     values stored in the configuration.
         */
        static void exportConfiguration(
            std::map<std::string, std::string>& exportedConfig);

        static const FnConfigHostSuite_v1* getSuite();
        static FnPluginStatus setHost(FnPluginHost* host);

    protected:

        Config();

        static const FnConfigHostSuite_v1 * _configSuite;
    };
    /** @} */
}
FNCONFIG_NAMESPACE_EXIT

#endif // FnConfig_H
